/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.messaging.integration;

import flex.messaging.FlexContext;
import flex.messaging.client.FlexClient;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.services.MessageService;
import flex.messaging.services.messaging.adapters.MessagingAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.flex.messaging.SubscribeEvent;
import org.springframework.flex.messaging.UnsubscribeEvent;
import org.springframework.flex.messaging.integration.FlexHeaders;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.core.SubscribableChannel;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.EventDrivenConsumer;
import org.springframework.integration.endpoint.PollingConsumer;
import org.springframework.integration.message.GenericMessage;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrationAdapter
extends MessagingAdapter
implements MessageHandler,
InitializingBean,
BeanNameAware,
ApplicationEventPublisherAware {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final List<String> filteredHeaders = new ArrayList<String>(FlexHeaders.ignored());
    private volatile MessageChannel messageChannel;
    private volatile boolean extractPayload = true;
    private volatile boolean filterSender = true;
    private volatile ApplicationEventPublisher applicationEventPublisher;
    private final Set<Object> subscriberIds = new HashSet<Object>();
    private final Map<Object, String> clientSubscriptions = new HashMap<Object, String>();
    private volatile AbstractEndpoint consumerEndpoint;

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.messageChannel, (String)"MessageChannel must not be null");
        if (this.messageChannel instanceof PollableChannel) {
            this.consumerEndpoint = new PollingConsumer((PollableChannel)this.messageChannel, (MessageHandler)this);
        } else if (this.messageChannel instanceof SubscribableChannel) {
            this.consumerEndpoint = new EventDrivenConsumer((SubscribableChannel)this.messageChannel, (MessageHandler)this);
        }
    }

    public void handleMessage(Message<?> message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("received Integration Message: " + message));
        }
        AsyncMessage flexMessage = new AsyncMessage();
        flexMessage.setBody(message.getPayload());
        MessageHeaders headers = message.getHeaders();
        flexMessage.setMessageId(headers.containsKey((Object)"flex_id") ? (String)headers.get((Object)"flex_id", String.class) : headers.getId().toString());
        Long timestamp = headers.containsKey((Object)"flex_timestamp") ? Long.parseLong((String)headers.get((Object)"flex_timestamp", String.class)) : headers.getTimestamp();
        flexMessage.setTimestamp(timestamp.longValue());
        Long expirationDate = headers.getExpirationDate();
        if (expirationDate != null) {
            flexMessage.setTimeToLive(expirationDate - timestamp);
        }
        if (headers.containsKey((Object)"flex_message_client_id")) {
            flexMessage.setClientId(headers.get((Object)"flex_message_client_id"));
        }
        for (Map.Entry header : headers.entrySet()) {
            String key = (String)header.getKey();
            if (filteredHeaders.contains(key)) continue;
            flexMessage.setHeader(key, header.getValue());
        }
        flexMessage.setDestination(this.getDestination().getId());
        MessageService messageService = (MessageService)this.getDestination().getService();
        if (this.filterSender && headers.containsKey((Object)"flex_client_id")) {
            HashSet<Object> subscribers = new HashSet<Object>(this.subscriberIds);
            FlexClient flexClient = messageService.getMessageBroker().getFlexClientManager().getFlexClient(headers.get((Object)"flex_client_id").toString());
            for (Object subscriberId : this.subscriberIds) {
                if (flexClient.getMessageClient(subscriberId.toString()) == null) continue;
                subscribers.remove(subscriberId);
            }
            messageService.pushMessageToClients(subscribers, (flex.messaging.messages.Message)flexMessage, true);
        } else {
            messageService.pushMessageToClients((flex.messaging.messages.Message)flexMessage, true);
        }
        messageService.sendPushMessageFromPeer((flex.messaging.messages.Message)flexMessage, true);
    }

    public boolean handlesSubscriptions() {
        return true;
    }

    public Object invoke(flex.messaging.messages.Message flexMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("received Flex Message: " + flexMessage));
        }
        GenericMessage message = null;
        if (this.extractPayload) {
            Map headers = flexMessage.getHeaders();
            headers.put("flex_message_client_id", flexMessage.getClientId());
            headers.put("flex_destination_id", flexMessage.getDestination());
            headers.put("flex_id", flexMessage.getMessageId());
            headers.put("flex_timestamp", String.valueOf(flexMessage.getTimestamp()));
            if (FlexContext.getFlexClient() != null) {
                headers.put("flex_client_id", FlexContext.getFlexClient().getId());
            }
            long timestamp = flexMessage.getTimestamp();
            message = MessageBuilder.withPayload((Object)flexMessage.getBody()).copyHeaders(headers).setExpirationDate(Long.valueOf(timestamp + flexMessage.getTimeToLive())).build();
        } else {
            message = new GenericMessage((Object)flexMessage);
        }
        this.messageChannel.send((Message)message);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object manage(CommandMessage commandMessage) {
        String clientId = (String)commandMessage.getClientId();
        if (commandMessage.getOperation() == 0) {
            this.subscriberIds.add(clientId);
            AbstractEndpoint abstractEndpoint = this.consumerEndpoint;
            synchronized (abstractEndpoint) {
                if (!this.consumerEndpoint.isRunning()) {
                    this.consumerEndpoint.start();
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("client [" + clientId + "] subscribed to destination [" + this.getDestination().getId() + "]"));
            }
            String flexClientId = FlexContext.getFlexClient().getId();
            this.clientSubscriptions.put(clientId, flexClientId);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new SubscribeEvent(flexClientId, clientId, this.getDestination().getId()));
        } else if (commandMessage.getOperation() == 1) {
            this.subscriberIds.remove(clientId);
            Object flexClientId = this.consumerEndpoint;
            synchronized (flexClientId) {
                if (this.subscriberIds.isEmpty() && this.consumerEndpoint.isRunning()) {
                    this.consumerEndpoint.stop();
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("client [" + clientId + "] unsubscribed from destination [" + this.getDestination().getId() + "]"));
            }
            flexClientId = this.clientSubscriptions.remove(clientId);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new UnsubscribeEvent(flexClientId, clientId, this.getDestination().getId()));
        }
        return null;
    }

    public void setBeanName(String beanName) {
        this.setId(beanName);
    }

    public void setMessageChannel(MessageChannel messageChannel) {
        this.messageChannel = messageChannel;
    }

    public void start() {
        super.start();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    static {
        filteredHeaders.add("id");
        filteredHeaders.add("timestamp");
        filteredHeaders.add("expirationDate");
    }
}

