/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import flex.messaging.FlexContext;
import flex.messaging.security.LoginCommand;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.NullRememberMeServices;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurityLoginCommand
implements LoginCommand,
InitializingBean {
    private final AuthenticationManager authManager;
    private List<LogoutHandler> logoutHandlers;
    private RememberMeServices rememberMeServices;
    private SessionAuthenticationStrategy sessionStrategy;
    private boolean perClientAuthentication = false;
    protected AuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();

    public SpringSecurityLoginCommand(AuthenticationManager authManager) {
        Assert.notNull((Object)authManager, (String)"AuthenticationManager is required.");
        this.authManager = authManager;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.sessionStrategy == null) {
            this.sessionStrategy = new NullAuthenticatedSessionStrategy();
        }
        if (this.rememberMeServices == null) {
            this.rememberMeServices = new NullRememberMeServices();
        }
        if (this.logoutHandlers == null) {
            this.logoutHandlers = new ArrayList<LogoutHandler>();
        }
        if (ClassUtils.isAssignableValue(LogoutHandler.class, (Object)this.rememberMeServices) && !this.logoutHandlers.contains(this.rememberMeServices)) {
            this.logoutHandlers.add((LogoutHandler)this.rememberMeServices);
        }
    }

    public Principal doAuthentication(String username, Object credentials) {
        HttpServletRequest request = FlexContext.getHttpRequest();
        HttpServletResponse response = FlexContext.getHttpResponse();
        try {
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)this.extractPassword(credentials));
            this.setDetails(request, authRequest);
            Authentication authentication = this.authManager.authenticate((Authentication)authRequest);
            if (authentication != null) {
                if (!this.isPerClientAuthentication() && request != null && response != null) {
                    this.sessionStrategy.onAuthentication(authentication, request, response);
                    this.rememberMeServices.loginSuccess(request, response, authentication);
                }
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
            return authentication;
        }
        catch (AuthenticationException ex) {
            SecurityContextHolder.clearContext();
            if (request != null && response != null && !this.isPerClientAuthentication()) {
                this.rememberMeServices.loginFail(request, response);
            }
            throw ex;
        }
    }

    public boolean doAuthorization(Principal principal, List roles) {
        Assert.isInstanceOf(Authentication.class, (Object)principal, (String)("This LoginCommand expects a Principal of type " + Authentication.class.getName()));
        Authentication auth = (Authentication)principal;
        if (auth == null || auth.getPrincipal() == null || auth.getAuthorities() == null) {
            return false;
        }
        for (GrantedAuthority grantedAuthority : auth.getAuthorities()) {
            if (!roles.contains(grantedAuthority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public AuthenticationManager getAuthManager() {
        return this.authManager;
    }

    public boolean isPerClientAuthentication() {
        return this.perClientAuthentication;
    }

    public boolean logout(Principal principal) {
        HttpServletRequest request = FlexContext.getHttpRequest();
        HttpServletResponse response = FlexContext.getHttpResponse();
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (request != null && response != null) {
            for (LogoutHandler handler : this.logoutHandlers) {
                handler.logout(request, response, auth);
            }
        } else {
            SecurityContextHolder.clearContext();
        }
        return true;
    }

    public void setLogoutHandlers(List<LogoutHandler> logoutHandlers) {
        this.logoutHandlers = logoutHandlers;
    }

    public void setPerClientAuthentication(boolean perClientAuthentication) {
        this.perClientAuthentication = perClientAuthentication;
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public void setSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionStrategy) {
        this.sessionStrategy = sessionStrategy;
    }

    public void start(ServletConfig config) {
    }

    public void stop() {
        SecurityContextHolder.clearContext();
    }

    protected String extractPassword(Object credentials) {
        String password = null;
        if (credentials instanceof String) {
            password = (String)credentials;
        } else if (credentials instanceof Map) {
            password = (String)((Map)credentials).get("password");
        }
        return password;
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }
}

