/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.graphql.execution.ThreadLocalAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public abstract class ReactorContextManager {
    private static final String CONTEXT_VIEW_KEY = ReactorContextManager.class.getName() + ".CONTEXT_VIEW";
    private static final String THREAD_ID = ReactorContextManager.class.getName() + ".THREAD_ID";
    private static final String THREAD_LOCAL_VALUES_KEY = ReactorContextManager.class.getName() + ".THREAD_VALUES_ACCESSOR";
    private static final String THREAD_LOCAL_ACCESSOR_KEY = ReactorContextManager.class.getName() + ".THREAD_LOCAL_ACCESSOR";

    static void setReactorContext(ContextView contextView, GraphQLContext graphQLContext) {
        graphQLContext.put((Object)CONTEXT_VIEW_KEY, (Object)contextView);
    }

    static ContextView getReactorContext(GraphQLContext graphQlContext) {
        Assert.notNull((Object)graphQlContext, (String)"GraphQLContext is required");
        return (ContextView)graphQlContext.getOrDefault((Object)CONTEXT_VIEW_KEY, (Object)Context.empty());
    }

    public static Context extractThreadLocalValues(ThreadLocalAccessor accessor, Context context) {
        LinkedHashMap<String, Object> valuesMap = new LinkedHashMap<String, Object>();
        accessor.extractValues(valuesMap);
        if (valuesMap.isEmpty()) {
            return context;
        }
        return context.putAll((ContextView)Context.of((Object)THREAD_LOCAL_VALUES_KEY, valuesMap, (Object)THREAD_LOCAL_ACCESSOR_KEY, (Object)accessor, (Object)THREAD_ID, (Object)Thread.currentThread().getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invokeCallable(Callable<T> callable, GraphQLContext graphQlContext) throws Exception {
        ContextView contextView = ReactorContextManager.getReactorContext(graphQlContext);
        try {
            ReactorContextManager.restoreThreadLocalValues(contextView);
            T t = callable.call();
            return t;
        }
        finally {
            ReactorContextManager.resetThreadLocalValues(contextView);
        }
    }

    static void restoreThreadLocalValues(ContextView contextView) {
        ThreadLocalAccessor accessor = ReactorContextManager.getThreadLocalAccessor(contextView);
        if (accessor != null) {
            accessor.restoreValues((Map)contextView.get((Object)THREAD_LOCAL_VALUES_KEY));
        }
    }

    static void resetThreadLocalValues(ContextView contextView) {
        ThreadLocalAccessor accessor = ReactorContextManager.getThreadLocalAccessor(contextView);
        if (accessor != null) {
            accessor.resetValues((Map)contextView.get((Object)THREAD_LOCAL_VALUES_KEY));
        }
    }

    @Nullable
    private static ThreadLocalAccessor getThreadLocalAccessor(ContextView view) {
        Long id = (Long)view.getOrDefault((Object)THREAD_ID, null);
        return id != null && id.longValue() != Thread.currentThread().getId() ? (ThreadLocalAccessor)view.get((Object)THREAD_LOCAL_ACCESSOR_KEY) : null;
    }
}

