/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.AnnotatedElement;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.ProjectedPayload;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.Argument;
import org.springframework.graphql.data.method.annotation.support.ArgumentMethodArgumentResolver;
import org.springframework.util.Assert;

public class ProjectedPayloadMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();

    public ProjectedPayloadMethodArgumentResolver(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        this.projectionFactory.setBeanFactory((BeanFactory)applicationContext);
        ClassLoader classLoader = applicationContext.getClassLoader();
        if (classLoader != null) {
            this.projectionFactory.setBeanClassLoader(classLoader);
        }
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        if (!type.isInterface()) {
            return false;
        }
        return AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)type, ProjectedPayload.class) != null;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) throws Exception {
        String name = parameter.hasParameterAnnotation(Argument.class) ? ArgumentMethodArgumentResolver.getArgumentName(parameter) : null;
        Object projectionSource = name != null ? environment.getArgument(name) : environment.getArguments();
        return this.project(parameter.getParameterType(), projectionSource);
    }

    protected Object project(Class<?> projectionType, Object projectionSource) {
        return this.projectionFactory.createProjection(projectionType, projectionSource);
    }
}

