/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.graphql.execution.ThreadLocalAccessor;

class CompositeThreadLocalAccessor
implements ThreadLocalAccessor {
    private final List<ThreadLocalAccessor> accessors;

    CompositeThreadLocalAccessor(List<ThreadLocalAccessor> accessors) {
        this.accessors = new ArrayList<ThreadLocalAccessor>(accessors);
    }

    @Override
    public void extractValues(Map<String, Object> container) {
        this.accessors.forEach(accessor -> accessor.extractValues(container));
    }

    @Override
    public void restoreValues(Map<String, Object> values) {
        this.accessors.forEach(accessor -> accessor.restoreValues(values));
    }

    @Override
    public void resetValues(Map<String, Object> values) {
        this.accessors.forEach(accessor -> accessor.resetValues(values));
    }
}

