/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLError;
import java.util.Collections;
import java.util.List;
import org.springframework.graphql.execution.ReactorContextManager;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public abstract class SubscriptionExceptionResolverAdapter
implements SubscriptionExceptionResolver {
    private boolean threadLocalContextAware;

    public void setThreadLocalContextAware(boolean threadLocalContextAware) {
        this.threadLocalContextAware = threadLocalContextAware;
    }

    public boolean isThreadLocalContextAware() {
        return this.threadLocalContextAware;
    }

    @Override
    public final Mono<List<GraphQLError>> resolveException(Throwable exception) {
        if (!this.threadLocalContextAware) {
            return Mono.justOrEmpty(this.resolveToMultipleErrors(exception));
        }
        return Mono.deferContextual(contextView -> {
            List<GraphQLError> errors;
            try {
                ReactorContextManager.restoreThreadLocalValues(contextView);
                errors = this.resolveToMultipleErrors(exception);
            }
            finally {
                ReactorContextManager.resetThreadLocalValues(contextView);
            }
            return Mono.justOrEmpty(errors);
        });
    }

    @Nullable
    protected List<GraphQLError> resolveToMultipleErrors(Throwable exception) {
        GraphQLError error = this.resolveToSingleError(exception);
        return error != null ? Collections.singletonList(error) : null;
    }

    @Nullable
    protected GraphQLError resolveToSingleError(Throwable exception) {
        return null;
    }
}

