/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Valid;
import jakarta.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

final class HandlerMethodValidationHelper {
    private final Validator validator;

    public HandlerMethodValidationHelper(Validator validator) {
        Assert.notNull((Object)validator, (String)"validator should not be null");
        this.validator = validator instanceof LocalValidatorFactoryBean ? ((LocalValidatorFactoryBean)validator).getValidator() : (validator instanceof SpringValidatorAdapter ? (Validator)validator.unwrap(Validator.class) : validator);
    }

    public void validate(HandlerMethod handlerMethod, Object[] arguments) {
        Set result = this.validator.forExecutables().validateParameters(handlerMethod.getBean(), handlerMethod.getMethod(), arguments, (Class[])this.determineValidationGroups(handlerMethod));
        if (!result.isEmpty()) {
            throw new ConstraintViolationException(result);
        }
    }

    private Class<?>[] determineValidationGroups(HandlerMethod method) {
        Validated annotation = HandlerMethodValidationHelper.findAnnotation(method, Validated.class);
        return annotation != null ? annotation.value() : new Class[]{};
    }

    @Nullable
    private static <A extends Annotation> A findAnnotation(HandlerMethod method, Class<A> annotationType) {
        Annotation annotation = AnnotationUtils.findAnnotation((Method)method.getMethod(), annotationType);
        if (annotation == null) {
            annotation = AnnotationUtils.findAnnotation(method.getBeanType(), annotationType);
        }
        return (A)annotation;
    }

    public boolean requiresValidation(HandlerMethod method) {
        if (HandlerMethodValidationHelper.findAnnotation(method, Validated.class) != null || HandlerMethodValidationHelper.findAnnotation(method, Valid.class) != null) {
            return true;
        }
        for (MethodParameter parameter : method.getMethodParameters()) {
            for (Annotation annotation : parameter.getParameterAnnotations()) {
                MergedAnnotations merged = MergedAnnotations.from((Annotation[])new Annotation[]{annotation});
                if (!merged.isPresent(Valid.class) && !merged.isPresent(Constraint.class) && !merged.isPresent(Validated.class)) continue;
                return true;
            }
            Class paramType = parameter.nestedIfOptional().getNestedParameterType();
            if (!this.validator.getConstraintsForClass(paramType).isBeanConstrained()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static HandlerMethodValidationHelper createIfValidatorAvailable(ApplicationContext context) {
        Validator validator = (Validator)context.getBeanProvider(Validator.class).getIfAvailable();
        return validator != null ? new HandlerMethodValidationHelper(validator) : null;
    }
}

