/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLError;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import io.micrometer.context.ContextSnapshot;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.graphql.execution.CompositeSubscriptionExceptionResolver;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;
import org.springframework.graphql.execution.SubscriptionPublisherException;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ContextDataFetcherDecorator
implements DataFetcher<Object> {
    private final DataFetcher<?> delegate;
    private final boolean subscription;
    private final SubscriptionExceptionResolver subscriptionExceptionResolver;

    private ContextDataFetcherDecorator(DataFetcher<?> delegate, boolean subscription, SubscriptionExceptionResolver subscriptionExceptionResolver) {
        Assert.notNull(delegate, (String)"'delegate' DataFetcher is required");
        Assert.notNull((Object)subscriptionExceptionResolver, (String)"'subscriptionExceptionResolver' is required");
        this.delegate = delegate;
        this.subscription = subscription;
        this.subscriptionExceptionResolver = subscriptionExceptionResolver;
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        ContextSnapshot snapshot = ContextSnapshot.captureFrom((Object)environment.getGraphQlContext());
        Object value = snapshot.wrap(() -> this.delegate.get(environment)).call();
        if (this.subscription) {
            Assert.state((boolean)(value instanceof Publisher), (String)"Expected Publisher for a subscription");
            Flux flux = Flux.from((Publisher)((Publisher)value)).onErrorResume(exception -> this.subscriptionExceptionResolver.resolveException((Throwable)exception).flatMap(errors -> Mono.error((Throwable)((Object)new SubscriptionPublisherException((List<GraphQLError>)errors, (Throwable)exception)))));
            return flux.contextWrite(arg_0 -> ((ContextSnapshot)snapshot).updateContext(arg_0));
        }
        if (value instanceof Flux) {
            value = ((Flux)value).collectList();
        }
        if (value instanceof Mono) {
            Mono valueMono = (Mono)value;
            value = valueMono.contextWrite(arg_0 -> ((ContextSnapshot)snapshot).updateContext(arg_0)).toFuture();
        }
        return value;
    }

    static GraphQLTypeVisitor createVisitor(List<SubscriptionExceptionResolver> resolvers) {
        final CompositeSubscriptionExceptionResolver compositeResolver = new CompositeSubscriptionExceptionResolver(resolvers);
        return new GraphQLTypeVisitorStub(){

            public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition fieldDefinition, TraverserContext<GraphQLSchemaElement> context) {
                GraphQLFieldsContainer parent;
                GraphQLCodeRegistry.Builder codeRegistry = (GraphQLCodeRegistry.Builder)context.getVarFromParents(GraphQLCodeRegistry.Builder.class);
                DataFetcher dataFetcher = codeRegistry.getDataFetcher(parent = (GraphQLFieldsContainer)context.getParentNode(), fieldDefinition);
                if (this.applyDecorator(dataFetcher)) {
                    boolean handlesSubscription = parent.getName().equals("Subscription");
                    dataFetcher = new ContextDataFetcherDecorator(dataFetcher, handlesSubscription, compositeResolver);
                    codeRegistry.dataFetcher(parent, fieldDefinition, dataFetcher);
                }
                return TraversalControl.CONTINUE;
            }

            private boolean applyDecorator(DataFetcher<?> dataFetcher) {
                Class<?> type = dataFetcher.getClass();
                String packageName = type.getPackage().getName();
                if (packageName.startsWith("graphql.")) {
                    return type.getSimpleName().startsWith("DataFetcherFactories") || packageName.startsWith("graphql.validation");
                }
                return true;
            }
        };
    }
}

