/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLError;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.graphql.execution.DataFetcherExceptionResolverAdapter;
import reactor.core.publisher.Mono;

public interface DataFetcherExceptionResolver {
    public Mono<List<GraphQLError>> resolveException(Throwable var1, DataFetchingEnvironment var2);

    public static DataFetcherExceptionResolverAdapter forSingleError(final BiFunction<Throwable, DataFetchingEnvironment, GraphQLError> resolver) {
        return new DataFetcherExceptionResolverAdapter(){

            @Override
            protected GraphQLError resolveToSingleError(Throwable ex, DataFetchingEnvironment env) {
                return (GraphQLError)resolver.apply(ex, env);
            }
        };
    }
}

