/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webmvc;

import java.net.URI;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import org.springframework.web.util.UriBuilder;

public class GraphiQlHandler {
    private final String graphQlPath;
    private final String graphQlWsPath;
    private final Resource htmlResource;

    public GraphiQlHandler(String graphQlPath, String graphQlWsPath) {
        this(graphQlPath, graphQlWsPath, (Resource)new ClassPathResource("graphiql/index.html"));
    }

    public GraphiQlHandler(String graphQlPath, String graphQlWsPath, Resource htmlResource) {
        Assert.hasText((String)graphQlPath, (String)"graphQlPath should not be empty");
        this.graphQlPath = graphQlPath;
        this.graphQlWsPath = graphQlWsPath;
        this.htmlResource = htmlResource;
    }

    public ServerResponse handleRequest(ServerRequest request) {
        return request.param("path").isPresent() ? ServerResponse.ok().contentType(MediaType.TEXT_HTML).body((Object)this.htmlResource) : ServerResponse.temporaryRedirect((URI)this.getRedirectUrl(request)).build();
    }

    private URI getRedirectUrl(ServerRequest request) {
        UriBuilder builder = request.uriBuilder();
        String pathQueryParam = this.applyPathPrefix(request, this.graphQlPath);
        builder.queryParam("path", new Object[]{pathQueryParam});
        if (StringUtils.hasText((String)this.graphQlWsPath)) {
            String wsPathQueryParam = this.applyPathPrefix(request, this.graphQlWsPath);
            builder.queryParam("wsPath", new Object[]{wsPathQueryParam});
        }
        return builder.build(request.pathVariables());
    }

    private String applyPathPrefix(ServerRequest request, String path) {
        String pathWithinApplication;
        String fullPath = request.requestPath().value();
        int pathWithinApplicationIndex = fullPath.indexOf(pathWithinApplication = request.requestPath().pathWithinApplication().toString());
        return pathWithinApplicationIndex != -1 ? fullPath.substring(0, pathWithinApplicationIndex) + path : path;
    }
}

