/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Valid;
import jakarta.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

class ValidationHelper {
    private final Validator validator;

    private ValidationHelper(Validator validator) {
        Assert.notNull((Object)validator, (String)"Validator is required");
        this.validator = validator;
    }

    @Nullable
    public Consumer<Object[]> getValidationHelperFor(HandlerMethod handlerMethod) {
        HandlerMethodValidator result;
        boolean requiresMethodValidation = false;
        Class[] methodValidationGroups = null;
        Validated validatedAnnotation = this.findAnnotation(handlerMethod, Validated.class);
        if (validatedAnnotation != null) {
            requiresMethodValidation = true;
            methodValidationGroups = validatedAnnotation.value();
        } else if (this.findAnnotation(handlerMethod, Valid.class) != null) {
            requiresMethodValidation = true;
        }
        MethodParameterValidator parameterValidator = null;
        MethodParameter[] parameters = handlerMethod.getMethodParameters();
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter parameter = parameters[i];
            for (Annotation annot : parameter.getParameterAnnotations()) {
                MergedAnnotations merged = MergedAnnotations.from((Annotation[])new Annotation[]{annot});
                if (merged.isPresent(Valid.class) || merged.isPresent(Constraint.class)) {
                    requiresMethodValidation = true;
                    continue;
                }
                if (!annot.annotationType().equals(Validated.class)) continue;
                Class[] groups = ((Validated)annot).value();
                parameterValidator = parameterValidator != null ? parameterValidator.andThen(new MethodParameterValidator(i, groups)) : new MethodParameterValidator(i, groups);
            }
        }
        HandlerMethodValidator handlerMethodValidator = result = requiresMethodValidation ? new HandlerMethodValidator(handlerMethod, methodValidationGroups) : null;
        if (parameterValidator != null) {
            return result != null ? result.andThen(parameterValidator) : parameterValidator;
        }
        return result;
    }

    @Nullable
    private <A extends Annotation> A findAnnotation(HandlerMethod method, Class<A> annotationType) {
        Annotation annotation = AnnotationUtils.findAnnotation((Method)method.getMethod(), annotationType);
        if (annotation == null) {
            annotation = AnnotationUtils.findAnnotation(method.getBeanType(), annotationType);
        }
        return (A)annotation;
    }

    @Nullable
    public static ValidationHelper createIfValidatorPresent(ApplicationContext context) {
        Validator validator = (Validator)context.getBeanProvider(Validator.class).getIfAvailable();
        if (validator instanceof LocalValidatorFactoryBean) {
            validator = ((LocalValidatorFactoryBean)validator).getValidator();
        } else if (validator instanceof SpringValidatorAdapter) {
            validator = (Validator)validator.unwrap(Validator.class);
        }
        return validator != null ? ValidationHelper.create(validator) : null;
    }

    public static ValidationHelper create(Validator validator) {
        return new ValidationHelper(validator);
    }

    private class MethodParameterValidator
    implements Consumer<Object[]> {
        private final int index;
        private final Class<?>[] validationGroups;

        MethodParameterValidator(@Nullable int index, Class<?>[] validationGroups) {
            this.index = index;
            this.validationGroups = validationGroups != null ? validationGroups : new Class[]{};
        }

        @Override
        public void accept(Object[] arguments) {
            Set violations = ValidationHelper.this.validator.validate(arguments[this.index], (Class[])this.validationGroups);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
    }

    private class HandlerMethodValidator
    implements Consumer<Object[]> {
        private final HandlerMethod handlerMethod;
        private final Class<?>[] validationGroups;

        HandlerMethodValidator(@Nullable HandlerMethod handlerMethod, Class<?>[] validationGroups) {
            Assert.notNull((Object)handlerMethod, (String)"HandlerMethod is required");
            this.handlerMethod = handlerMethod;
            this.validationGroups = validationGroups != null ? validationGroups : new Class[]{};
        }

        @Override
        public void accept(Object[] arguments) {
            Set violations = ValidationHelper.this.validator.forExecutables().validateParameters(this.handlerMethod.getBean(), this.handlerMethod.getMethod(), arguments, (Class[])this.validationGroups);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
    }
}

