/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webflux;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

public class GraphQlHttpHandler {
    private static final Log logger = LogFactory.getLog(GraphQlHttpHandler.class);
    private static final MediaType APPLICATION_GRAPHQL_RESPONSE = new MediaType("application", "graphql-response+json");
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_PARAMETERIZED_TYPE_REF = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = Arrays.asList(APPLICATION_GRAPHQL_RESPONSE, MediaType.APPLICATION_JSON, MediaType.APPLICATION_GRAPHQL);
    private final WebGraphQlHandler graphQlHandler;

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler) {
        Assert.notNull((Object)graphQlHandler, (String)"WebGraphQlHandler is required");
        this.graphQlHandler = graphQlHandler;
    }

    public Mono<ServerResponse> handleRequest(ServerRequest serverRequest) {
        return serverRequest.bodyToMono(MAP_PARAMETERIZED_TYPE_REF).flatMap(body -> {
            WebGraphQlRequest graphQlRequest = new WebGraphQlRequest(serverRequest.uri(), serverRequest.headers().asHttpHeaders(), (Map<String, Object>)body, serverRequest.exchange().getRequest().getId(), serverRequest.exchange().getLocaleContext().getLocale());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing: " + graphQlRequest));
            }
            return this.graphQlHandler.handleRequest(graphQlRequest);
        }).flatMap(response -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Execution complete");
            }
            ServerResponse.BodyBuilder builder = ServerResponse.ok();
            builder.headers(headers -> headers.putAll((Map)response.getResponseHeaders()));
            builder.contentType(GraphQlHttpHandler.selectResponseMediaType(serverRequest));
            return builder.bodyValue(response.toMap());
        });
    }

    private static MediaType selectResponseMediaType(ServerRequest serverRequest) {
        for (MediaType accepted : serverRequest.headers().accept()) {
            if (!SUPPORTED_MEDIA_TYPES.contains(accepted)) continue;
            return accepted;
        }
        return MediaType.APPLICATION_JSON;
    }
}

