/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.graphql.client.AbstractDelegatingGraphQlClient;
import org.springframework.graphql.client.AbstractGraphQlClientBuilder;
import org.springframework.graphql.client.CodecDelegate;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.WebSocketGraphQlClient;
import org.springframework.graphql.client.WebSocketGraphQlClientInterceptor;
import org.springframework.graphql.client.WebSocketGraphQlTransport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.util.DefaultUriBuilderFactory;
import reactor.core.publisher.Mono;

final class DefaultWebSocketGraphQlClientBuilder
extends AbstractGraphQlClientBuilder<DefaultWebSocketGraphQlClientBuilder>
implements WebSocketGraphQlClient.Builder<DefaultWebSocketGraphQlClientBuilder> {
    private URI url;
    private final HttpHeaders headers = new HttpHeaders();
    private final WebSocketClient webSocketClient;
    private final CodecConfigurer codecConfigurer;

    DefaultWebSocketGraphQlClientBuilder(String url, WebSocketClient client) {
        this(DefaultWebSocketGraphQlClientBuilder.toURI(url), client);
    }

    DefaultWebSocketGraphQlClientBuilder(URI url, WebSocketClient client) {
        this.url = url;
        this.webSocketClient = client;
        this.codecConfigurer = ClientCodecConfigurer.create();
    }

    DefaultWebSocketGraphQlClientBuilder(WebSocketGraphQlTransport transport) {
        this.url = transport.getUrl();
        this.headers.putAll((Map)transport.getHeaders());
        this.webSocketClient = transport.getWebSocketClient();
        this.codecConfigurer = transport.getCodecConfigurer();
    }

    @Override
    public DefaultWebSocketGraphQlClientBuilder url(String url) {
        return this.url(DefaultWebSocketGraphQlClientBuilder.toURI(url));
    }

    @Override
    public DefaultWebSocketGraphQlClientBuilder url(URI url) {
        this.url = url;
        return this;
    }

    private static URI toURI(String url) {
        return new DefaultUriBuilderFactory().uriString(url).build(new Object[0]);
    }

    @Override
    public DefaultWebSocketGraphQlClientBuilder header(String name, String ... values) {
        this.headers.put(name, Arrays.asList(values));
        return this;
    }

    @Override
    public DefaultWebSocketGraphQlClientBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public DefaultWebSocketGraphQlClientBuilder codecConfigurer(Consumer<CodecConfigurer> codecConfigurerConsumer) {
        codecConfigurerConsumer.accept(this.codecConfigurer);
        return this;
    }

    @Override
    public WebSocketGraphQlClient build() {
        this.setJsonCodecs(CodecDelegate.findJsonEncoder(this.codecConfigurer), CodecDelegate.findJsonDecoder(this.codecConfigurer));
        WebSocketGraphQlTransport transport = new WebSocketGraphQlTransport(this.url, this.headers, this.webSocketClient, this.codecConfigurer, this.getInterceptor());
        GraphQlClient graphQlClient = super.buildGraphQlClient(transport);
        return new DefaultWebSocketGraphQlClient(graphQlClient, transport, this.getBuilderInitializer());
    }

    private WebSocketGraphQlClientInterceptor getInterceptor() {
        List<WebSocketGraphQlClientInterceptor> interceptors = this.getInterceptors().stream().filter(interceptor -> interceptor instanceof WebSocketGraphQlClientInterceptor).map(interceptor -> (WebSocketGraphQlClientInterceptor)interceptor).toList();
        Assert.state((interceptors.size() <= 1 ? 1 : 0) != 0, (String)"Only a single interceptor of type WebSocketGraphQlClientInterceptor may be configured");
        return !interceptors.isEmpty() ? interceptors.get(0) : new WebSocketGraphQlClientInterceptor(){};
    }

    private static class DefaultWebSocketGraphQlClient
    extends AbstractDelegatingGraphQlClient
    implements WebSocketGraphQlClient {
        private final WebSocketGraphQlTransport transport;
        private final Consumer<AbstractGraphQlClientBuilder<?>> builderInitializer;

        DefaultWebSocketGraphQlClient(GraphQlClient delegate, WebSocketGraphQlTransport transport, Consumer<AbstractGraphQlClientBuilder<?>> builderInitializer) {
            super(delegate);
            Assert.notNull((Object)transport, (String)"WebSocketGraphQlTransport is required");
            Assert.notNull(builderInitializer, (String)"`builderInitializer` is required");
            this.transport = transport;
            this.builderInitializer = builderInitializer;
        }

        @Override
        public Mono<Void> start() {
            return this.transport.start();
        }

        @Override
        public Mono<Void> stop() {
            return this.transport.stop();
        }

        @Override
        public DefaultWebSocketGraphQlClientBuilder mutate() {
            DefaultWebSocketGraphQlClientBuilder builder = new DefaultWebSocketGraphQlClientBuilder(this.transport);
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

