/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webflux;

import java.net.URI;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;

public class GraphiQlHandler {
    private final String graphQlPath;
    private final String graphQlWsPath;
    private final Resource htmlResource;

    public GraphiQlHandler(String graphQlPath, String graphQlWsPath) {
        this(graphQlPath, graphQlWsPath, (Resource)new ClassPathResource("graphiql/index.html"));
    }

    public GraphiQlHandler(String graphQlPath, String graphQlWsPath, Resource htmlResource) {
        this.graphQlPath = graphQlPath;
        this.graphQlWsPath = graphQlWsPath;
        this.htmlResource = htmlResource;
    }

    public Mono<ServerResponse> handleRequest(ServerRequest request) {
        return request.queryParam("path").isPresent() ? ServerResponse.ok().contentType(MediaType.TEXT_HTML).bodyValue((Object)this.htmlResource) : ServerResponse.temporaryRedirect((URI)this.getRedirectUrl(request)).build();
    }

    private URI getRedirectUrl(ServerRequest request) {
        UriBuilder builder = request.uriBuilder();
        String pathQueryParam = this.applyContextPath(request, this.graphQlPath);
        builder.queryParam("path", new Object[]{pathQueryParam});
        if (StringUtils.hasText((String)this.graphQlWsPath)) {
            String wsPathQueryParam = this.applyContextPath(request, this.graphQlWsPath);
            builder.queryParam("wsPath", new Object[]{wsPathQueryParam});
        }
        return builder.build(request.pathVariables());
    }

    private String applyContextPath(ServerRequest request, String path) {
        String contextPath = request.requestPath().contextPath().toString();
        return StringUtils.hasText((String)contextPath) ? contextPath + path : path;
    }
}

