/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.federation;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DelegatingDataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.method.annotation.support.ArgumentMethodArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindException;

final class EntityArgumentMethodArgumentResolver
extends ArgumentMethodArgumentResolver {
    EntityArgumentMethodArgumentResolver(GraphQlArgumentBinder argumentBinder) {
        super(argumentBinder);
    }

    @Override
    protected Object doBind(DataFetchingEnvironment environment, String name, ResolvableType targetType) throws BindException {
        if (environment instanceof EntityDataFetchingEnvironment) {
            EntityDataFetchingEnvironment entityEnv = (EntityDataFetchingEnvironment)environment;
            return this.doBind(name, targetType, entityEnv.getRepresentation());
        }
        if (environment instanceof EntityBatchDataFetchingEnvironment) {
            EntityBatchDataFetchingEnvironment batchEnv = (EntityBatchDataFetchingEnvironment)environment;
            name = EntityArgumentMethodArgumentResolver.dePluralize(name);
            targetType = targetType.getNested(2);
            ArrayList<Object> values = new ArrayList<Object>();
            for (Map<String, Object> representation : batchEnv.getRepresentations()) {
                values.add(this.doBind(name, targetType, representation));
            }
            return values;
        }
        throw new IllegalStateException("Expected decorated DataFetchingEnvironment");
    }

    @Nullable
    private Object doBind(String name, ResolvableType targetType, Map<String, Object> entityMap) throws BindException {
        Object rawValue = entityMap.get(name);
        boolean isOmitted = !entityMap.containsKey(name);
        return this.getArgumentBinder().bind(rawValue, isOmitted, targetType);
    }

    private static String dePluralize(String name) {
        return name.endsWith("List") ? name.substring(0, name.length() - 4) : name;
    }

    static DataFetchingEnvironment wrap(DataFetchingEnvironment env, Map<String, Object> representation) {
        return new EntityDataFetchingEnvironment(env, representation);
    }

    static DataFetchingEnvironment wrap(DataFetchingEnvironment env, List<Map<String, Object>> representations) {
        return new EntityBatchDataFetchingEnvironment(env, representations);
    }

    static class EntityDataFetchingEnvironment
    extends DelegatingDataFetchingEnvironment {
        private final Map<String, Object> representation;

        EntityDataFetchingEnvironment(DataFetchingEnvironment env, Map<String, Object> representation) {
            super(env);
            this.representation = representation;
        }

        Map<String, Object> getRepresentation() {
            return this.representation;
        }
    }

    static class EntityBatchDataFetchingEnvironment
    extends DelegatingDataFetchingEnvironment {
        private final List<Map<String, Object>> representations;

        EntityBatchDataFetchingEnvironment(DataFetchingEnvironment env, List<Map<String, Object>> representations) {
            super(env);
            this.representations = representations;
        }

        List<Map<String, Object>> getRepresentations() {
            return this.representations;
        }
    }
}

