/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.hateoas.core.DummyInvocationUtils;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.hateoas.mvc.Java8Utils;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

class AnnotatedParametersParameterAccessor {
    private static final Map<Method, MethodParameters> METHOD_PARAMETERS_CACHE = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    @NonNull
    private final AnnotationAttribute attribute;

    public List<BoundMethodParameter> getBoundParameters(DummyInvocationUtils.MethodInvocation invocation) {
        Assert.notNull((Object)invocation, (String)"MethodInvocation must not be null!");
        MethodParameters parameters = AnnotatedParametersParameterAccessor.getOrCreateMethodParametersFor(invocation.getMethod());
        Object[] arguments = invocation.getArguments();
        ArrayList<BoundMethodParameter> result = new ArrayList<BoundMethodParameter>();
        for (MethodParameter parameter : parameters.getParametersWith(this.attribute.getAnnotationType())) {
            Object value;
            Object verifiedValue = this.verifyParameterValue(parameter, value = arguments[parameter.getParameterIndex()]);
            if (verifiedValue == null) continue;
            result.add(this.createParameter(parameter, verifiedValue, this.attribute));
        }
        return result;
    }

    protected BoundMethodParameter createParameter(MethodParameter parameter, Object value, AnnotationAttribute attribute) {
        return new BoundMethodParameter(parameter, value, attribute);
    }

    protected Object verifyParameterValue(MethodParameter parameter, Object value) {
        return value;
    }

    private static MethodParameters getOrCreateMethodParametersFor(Method method) {
        MethodParameters methodParameters = METHOD_PARAMETERS_CACHE.get(method);
        if (methodParameters != null) {
            return methodParameters;
        }
        methodParameters = new MethodParameters(method);
        METHOD_PARAMETERS_CACHE.put(method, methodParameters);
        return methodParameters;
    }

    @ConstructorProperties(value={"attribute"})
    public AnnotatedParametersParameterAccessor(@NonNull AnnotationAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        this.attribute = attribute;
    }

    static class BoundMethodParameter {
        private static final ConversionService CONVERSION_SERVICE = new DefaultFormattingConversionService();
        private static final TypeDescriptor STRING_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
        private final MethodParameter parameter;
        private final Object value;
        private final AnnotationAttribute attribute;
        private final TypeDescriptor parameterTypeDescriptor;

        public BoundMethodParameter(MethodParameter parameter, Object value, AnnotationAttribute attribute) {
            Assert.notNull((Object)parameter, (String)"MethodParameter must not be null!");
            boolean isOptional = Java8Utils.isJava8Optional(parameter.getParameterType());
            this.parameter = parameter;
            this.value = value;
            this.attribute = attribute;
            this.parameterTypeDescriptor = TypeDescriptor.nested((MethodParameter)parameter, (int)(isOptional ? 1 : 0));
        }

        public String getVariableName() {
            if (this.attribute == null) {
                return this.parameter.getParameterName();
            }
            Annotation annotation = this.parameter.getParameterAnnotation(this.attribute.getAnnotationType());
            String annotationAttributeValue = this.attribute.getValueFrom(annotation);
            return StringUtils.hasText((String)annotationAttributeValue) ? annotationAttributeValue : this.parameter.getParameterName();
        }

        public Object getValue() {
            return this.value;
        }

        public String asString() {
            return this.value == null ? null : (String)CONVERSION_SERVICE.convert(this.value, this.parameterTypeDescriptor, STRING_DESCRIPTOR);
        }

        public boolean isRequired() {
            return true;
        }
    }
}

