/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public final class Hop {
    private final String rel;
    private final Map<String, ? extends Object> parameters;

    public static Hop rel(String rel) {
        Assert.hasText((String)rel, (String)"Relation must not be null or empty!");
        return new Hop(rel, Collections.emptyMap());
    }

    public Hop withParameter(String name, Object value) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        HashMap<String, ? extends Object> parameters = new HashMap<String, Object>(this.parameters);
        parameters.put(name, value);
        return new Hop(this.rel, parameters);
    }

    boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    Map<String, Object> getMergedParameters(Map<String, Object> globalParameters) {
        Assert.notNull(globalParameters, (String)"Global parameters must not be null!");
        HashMap<String, Object> mergedParameters = new HashMap<String, Object>();
        mergedParameters.putAll(globalParameters);
        mergedParameters.putAll(this.parameters);
        return mergedParameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hop)) {
            return false;
        }
        Hop other = (Hop)o;
        String this$rel = this.getRel();
        String other$rel = other.getRel();
        if (this$rel == null ? other$rel != null : !this$rel.equals(other$rel)) {
            return false;
        }
        Map<String, ? extends Object> this$parameters = this.getParameters();
        Map<String, ? extends Object> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rel = this.getRel();
        result = result * 59 + ($rel == null ? 43 : $rel.hashCode());
        Map<String, ? extends Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "Hop(rel=" + this.getRel() + ", parameters=" + this.getParameters() + ")";
    }

    private Hop(String rel, Map<String, ? extends Object> parameters) {
        this.rel = rel;
        this.parameters = parameters;
    }

    String getRel() {
        return this.rel;
    }

    Map<String, ? extends Object> getParameters() {
        return this.parameters;
    }

    public Hop withParameters(Map<String, ? extends Object> parameters) {
        return this.parameters == parameters ? this : new Hop(this.rel, parameters);
    }
}

