/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.config.WebClientConfigurer;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.lang.NonNull;
import org.springframework.util.MimeType;
import org.springframework.web.filter.reactive.ServerWebExchangeContextFilter;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
class WebFluxHateoasConfiguration {
    WebFluxHateoasConfiguration() {
    }

    @Bean
    WebClientConfigurer webClientConfigurer(ObjectProvider<ObjectMapper> mapper, List<HypermediaMappingInformation> hypermediaTypes) {
        return new WebClientConfigurer((ObjectMapper)mapper.getIfAvailable(ObjectMapper::new), hypermediaTypes);
    }

    @Bean
    static HypermediaWebClientBeanPostProcessor webClientBeanPostProcessor(ObjectProvider<WebClientConfigurer> configurer) {
        return new HypermediaWebClientBeanPostProcessor(configurer);
    }

    @Bean
    HypermediaWebFluxConfigurer hypermediaWebFluxConfigurer(ObjectProvider<ObjectMapper> mapper, List<HypermediaMappingInformation> hypermediaTypes) {
        return new HypermediaWebFluxConfigurer((ObjectMapper)mapper.getIfAvailable(ObjectMapper::new), hypermediaTypes);
    }

    @Bean
    @Lazy
    ServerWebExchangeContextFilter serverWebExchangeContextFilter() {
        return new ServerWebExchangeContextFilter();
    }

    static class HypermediaWebFluxConfigurer
    implements WebFluxConfigurer {
        private final ObjectMapper mapper;
        private final List<HypermediaMappingInformation> hypermediaTypes;

        public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
            this.hypermediaTypes.forEach(hypermedia -> {
                ObjectMapper objectMapper = hypermedia.configureObjectMapper(this.mapper.copy());
                MimeType[] mimeTypes = hypermedia.getMediaTypes().toArray(new MimeType[0]);
                configurer.customCodecs().encoder((Encoder)new Jackson2JsonEncoder(objectMapper, mimeTypes));
                configurer.customCodecs().decoder((Decoder)new Jackson2JsonDecoder(objectMapper, mimeTypes));
            });
        }

        @Generated
        public HypermediaWebFluxConfigurer(ObjectMapper mapper, List<HypermediaMappingInformation> hypermediaTypes) {
            this.mapper = mapper;
            this.hypermediaTypes = hypermediaTypes;
        }
    }

    static class HypermediaWebClientBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectProvider<WebClientConfigurer> configurer;

        @NonNull
        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof WebClient) {
                return ((WebClientConfigurer)this.configurer.getObject()).registerHypermediaTypes((WebClient)bean);
            }
            return bean;
        }

        @Generated
        public HypermediaWebClientBeanPostProcessor(ObjectProvider<WebClientConfigurer> configurer) {
            this.configurer = configurer;
        }
    }
}

