/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsAffordanceModel;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsProperty;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class HalFormsTemplateBuilder {
    private final HalFormsConfiguration configuration;
    private final MessageResolver resolver;

    public Map<String, HalFormsTemplate> findTemplates(RepresentationModel<?> resource) {
        if (!resource.hasLink(IanaLinkRelations.SELF)) {
            return Collections.emptyMap();
        }
        HashMap<String, HalFormsTemplate> templates = new HashMap<String, HalFormsTemplate>();
        List affordances = resource.getLink(IanaLinkRelations.SELF).map(Link::getAffordances).orElse(Collections.emptyList());
        affordances.stream().map(it -> it.getAffordanceModel(MediaTypes.HAL_FORMS_JSON)).peek(it -> Assert.notNull((Object)it, (String)"No HAL Forms affordance model found but expected!")).map(HalFormsAffordanceModel.class::cast).filter(it -> !it.hasHttpMethod(HttpMethod.GET)).forEach(it -> {
            PropertyCustomizations propertyCustomizations = this.forMetadata(it.getInput());
            List<HalFormsProperty> propertiesWithPrompt = it.getInputProperties().stream().map(property -> propertyCustomizations.apply(property)).map(property -> it.hasHttpMethod(HttpMethod.PATCH) ? property.withRequired(false) : property).collect(Collectors.toList());
            HalFormsTemplate template = HalFormsTemplate.forMethod(it.getHttpMethod()).withProperties(propertiesWithPrompt);
            template = this.applyTo(template, TemplateTitle.of(it, templates.isEmpty()));
            templates.put(templates.isEmpty() ? "default" : it.getName(), template);
        });
        return templates;
    }

    public PropertyCustomizations forMetadata(AffordanceModel.InputPayloadMetadata metadata) {
        return new PropertyCustomizations(metadata);
    }

    public HalFormsTemplate applyTo(HalFormsTemplate template, TemplateTitle templateTitle) {
        return Optional.ofNullable(this.resolver.resolve(templateTitle)).map(template::withTitle).orElse(template);
    }

    @Generated
    public HalFormsTemplateBuilder(HalFormsConfiguration configuration, MessageResolver resolver) {
        this.configuration = configuration;
        this.resolver = resolver;
    }

    static class PropertyPrompt
    implements MessageSourceResolvable {
        private static final String PROMPT_TEMPLATE = "%s._prompt";
        private final AffordanceModel.InputPayloadMetadata metadata;
        private final HalFormsProperty property;

        @Nullable
        public String getDefaultMessage() {
            return "";
        }

        @NonNull
        public String[] getCodes() {
            String globalCode = String.format(PROMPT_TEMPLATE, this.property.getName());
            ArrayList<String> codes = new ArrayList<String>();
            this.metadata.getI18nCodes().stream().map(it -> String.format("%s.%s", it, globalCode)).forEach(codes::add);
            codes.add(globalCode);
            return codes.toArray(new String[0]);
        }

        @Generated
        private PropertyPrompt(AffordanceModel.InputPayloadMetadata metadata, HalFormsProperty property) {
            this.metadata = metadata;
            this.property = property;
        }

        @Generated
        public static PropertyPrompt of(AffordanceModel.InputPayloadMetadata metadata, HalFormsProperty property) {
            return new PropertyPrompt(metadata, property);
        }
    }

    static class TemplateTitle
    implements MessageSourceResolvable {
        private static final String TEMPLATE_TEMPLATE = "_templates.%s.title";
        private final HalFormsAffordanceModel affordance;
        private final boolean soleTemplate;

        @NonNull
        public String[] getCodes() {
            Stream<String> seed = Stream.concat(Stream.of(this.affordance.getName()), this.soleTemplate ? Stream.of("default") : Stream.empty());
            return (String[])seed.flatMap(it -> TemplateTitle.getCodesFor(it, this.affordance.getInput())).toArray(String[]::new);
        }

        private static Stream<String> getCodesFor(String name, AffordanceModel.InputPayloadMetadata type) {
            String global = String.format(TEMPLATE_TEMPLATE, name);
            Stream<String> inputBased = type.getI18nCodes().stream().map(it -> String.format("%s.%s", it, global));
            return Stream.concat(inputBased, Stream.of(global));
        }

        @Nullable
        public String getDefaultMessage() {
            return "";
        }

        @Generated
        private TemplateTitle(HalFormsAffordanceModel affordance, boolean soleTemplate) {
            this.affordance = affordance;
            this.soleTemplate = soleTemplate;
        }

        @Generated
        public static TemplateTitle of(HalFormsAffordanceModel affordance, boolean soleTemplate) {
            return new TemplateTitle(affordance, soleTemplate);
        }
    }

    class PropertyCustomizations {
        private final AffordanceModel.InputPayloadMetadata metadata;

        private HalFormsProperty apply(HalFormsProperty property) {
            String message = HalFormsTemplateBuilder.this.resolver.resolve(PropertyPrompt.of(this.metadata, property));
            HalFormsProperty withPrompt = Optional.ofNullable(message).map(it -> property.withPrompt((String)it)).orElse(property);
            HalFormsProperty withConfig = this.metadata.getPropertyMetadata(withPrompt.getName()).flatMap(it -> this.applyConfig((AffordanceModel.PropertyMetadata)it, withPrompt)).orElse(withPrompt);
            return this.metadata.applyTo(withConfig);
        }

        private Optional<HalFormsProperty> applyConfig(AffordanceModel.PropertyMetadata metadata, HalFormsProperty property) {
            return HalFormsTemplateBuilder.this.configuration.getTypePatternFor(metadata.getType()).map(property::withRegex);
        }

        @Generated
        public PropertyCustomizations(AffordanceModel.InputPayloadMetadata metadata) {
            this.metadata = metadata;
        }
    }
}

