/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.QueryParameter;
import org.springframework.hateoas.mediatype.Affordances;
import org.springframework.hateoas.server.core.MappingDiscoverer;
import org.springframework.hateoas.server.core.MethodParameters;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class SpringAffordanceBuilder {
    public static List<Affordance> create(Class<?> type, Method method, String href, MappingDiscoverer discoverer) {
        String methodName = method.getName();
        Link affordanceLink = new Link(href, LinkRelation.of(methodName));
        MethodParameters parameters = MethodParameters.of(method);
        ResolvableType inputType = parameters.getParametersWith(RequestBody.class).stream().findFirst().map(ResolvableType::forMethodParameter).orElse(ResolvableType.NONE);
        List queryMethodParameters = parameters.getParametersWith(RequestParam.class).stream().map(QueryParameter::of).collect(Collectors.toList());
        ResolvableType outputType = ResolvableType.forMethodReturnType((Method)method);
        Affordances affordances = Affordances.of(affordanceLink);
        return discoverer.getRequestMethod(type, method).stream().flatMap(it -> affordances.afford((HttpMethod)it).withInput(inputType).withOutput(outputType).withParameters(queryMethodParameters).withName(methodName).build().stream()).collect(Collectors.toList());
    }
}

