/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.QueryParameter;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public abstract class AffordanceModel {
    private String name;
    private Link link;
    private HttpMethod httpMethod;
    private InputPayloadMetadata input;
    private List<QueryParameter> queryMethodParameters;
    private PayloadMetadata output;

    public String getURI() {
        return this.link.expand(new Object[0]).getHref();
    }

    public boolean hasHttpMethod(HttpMethod method) {
        Assert.notNull((Object)method, (String)"HttpMethod must not be null!");
        return this.httpMethod.equals((Object)method);
    }

    public boolean pointsToTargetOf(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        return this.getURI().equals(link.expand(new Object[0]).getHref());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AffordanceModel)) {
            return false;
        }
        AffordanceModel other = (AffordanceModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Link this$link = this.getLink();
        Link other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
            return false;
        }
        InputPayloadMetadata this$input = this.getInput();
        InputPayloadMetadata other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        List<QueryParameter> this$queryMethodParameters = this.getQueryMethodParameters();
        List<QueryParameter> other$queryMethodParameters = other.getQueryMethodParameters();
        if (this$queryMethodParameters == null ? other$queryMethodParameters != null : !((Object)this$queryMethodParameters).equals(other$queryMethodParameters)) {
            return false;
        }
        PayloadMetadata this$output = this.getOutput();
        PayloadMetadata other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !this$output.equals(other$output));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AffordanceModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Link $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        InputPayloadMetadata $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        List<QueryParameter> $queryMethodParameters = this.getQueryMethodParameters();
        result = result * 59 + ($queryMethodParameters == null ? 43 : ((Object)$queryMethodParameters).hashCode());
        PayloadMetadata $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        return result;
    }

    @Generated
    public AffordanceModel(String name, Link link, HttpMethod httpMethod, InputPayloadMetadata input, List<QueryParameter> queryMethodParameters, PayloadMetadata output) {
        this.name = name;
        this.link = link;
        this.httpMethod = httpMethod;
        this.input = input;
        this.queryMethodParameters = queryMethodParameters;
        this.output = output;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Link getLink() {
        return this.link;
    }

    @Generated
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public InputPayloadMetadata getInput() {
        return this.input;
    }

    @Generated
    public List<QueryParameter> getQueryMethodParameters() {
        return this.queryMethodParameters;
    }

    @Generated
    public PayloadMetadata getOutput() {
        return this.output;
    }

    private static enum NoPayloadMetadata implements PayloadMetadata
    {
        INSTANCE;


        @Override
        public Stream<PropertyMetadata> stream() {
            return Stream.empty();
        }
    }

    public static interface Named {
        public String getName();
    }

    public static interface PropertyMetadataConfigured<T> {
        public T apply(PropertyMetadata var1);
    }

    public static interface PropertyMetadata {
        public String getName();

        default public boolean hasName(String name) {
            Assert.hasText((String)name, (String)"Name must not be null or empty!");
            return this.getName().equals(name);
        }

        public boolean isRequired();

        public boolean isReadOnly();

        public Optional<String> getPattern();

        public ResolvableType getType();
    }

    private static class DelegatingInputPayloadMetadata
    implements InputPayloadMetadata {
        private final PayloadMetadata metadata;

        @Override
        public Stream<PropertyMetadata> stream() {
            return this.metadata.stream();
        }

        @Override
        public <T extends PropertyMetadataConfigured<T> & Named> T applyTo(T target) {
            return target;
        }

        @Override
        public <T extends Named> T customize(T target, Function<PropertyMetadata, T> customizer) {
            return target;
        }

        @Override
        public List<String> getI18nCodes() {
            return Collections.emptyList();
        }

        @Generated
        public String toString() {
            return "AffordanceModel.DelegatingInputPayloadMetadata(metadata=" + this.metadata + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DelegatingInputPayloadMetadata)) {
                return false;
            }
            DelegatingInputPayloadMetadata other = (DelegatingInputPayloadMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PayloadMetadata this$metadata = this.metadata;
            PayloadMetadata other$metadata = other.metadata;
            return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DelegatingInputPayloadMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PayloadMetadata $metadata = this.metadata;
            result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
            return result;
        }

        @Generated
        private DelegatingInputPayloadMetadata(PayloadMetadata metadata) {
            this.metadata = metadata;
        }

        @Generated
        public static DelegatingInputPayloadMetadata of(PayloadMetadata metadata) {
            return new DelegatingInputPayloadMetadata(metadata);
        }
    }

    public static interface InputPayloadMetadata
    extends PayloadMetadata {
        public static final InputPayloadMetadata NONE = InputPayloadMetadata.from(PayloadMetadata.NONE);

        public static InputPayloadMetadata from(PayloadMetadata metadata) {
            return InputPayloadMetadata.class.isInstance(metadata) ? (InputPayloadMetadata)InputPayloadMetadata.class.cast(metadata) : DelegatingInputPayloadMetadata.of(metadata);
        }

        public <T extends PropertyMetadataConfigured<T> & Named> T applyTo(T var1);

        public <T extends Named> T customize(T var1, Function<PropertyMetadata, T> var2);

        public List<String> getI18nCodes();
    }

    public static interface PayloadMetadata {
        public static final PayloadMetadata NONE = NoPayloadMetadata.INSTANCE;

        public Stream<PropertyMetadata> stream();

        default public Optional<PropertyMetadata> getPropertyMetadata(String name) {
            return this.stream().filter(it -> it.hasName(name)).findFirst();
        }
    }
}

