/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonError;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonItem;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonQuery;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonTemplate;
import org.springframework.lang.Nullable;

final class CollectionJson<T> {
    private final String version;
    @Nullable
    private final String href;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Links links;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<CollectionJsonItem<T>> items;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<CollectionJsonQuery> queries;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final CollectionJsonTemplate template;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final CollectionJsonError error;

    @JsonCreator
    CollectionJson(@JsonProperty(value="version") String version, @JsonProperty(value="href") @Nullable String href, @JsonProperty(value="links") @Nullable Links links, @JsonProperty(value="items") @Nullable List<CollectionJsonItem<T>> items, @JsonProperty(value="queries") @Nullable List<CollectionJsonQuery> queries, @JsonProperty(value="template") @Nullable CollectionJsonTemplate template, @JsonProperty(value="error") @Nullable CollectionJsonError error) {
        this.version = version;
        this.href = href;
        this.links = links == null ? Links.NONE : links;
        this.items = items == null ? Collections.emptyList() : items;
        this.queries = queries == null ? Collections.emptyList() : queries;
        this.template = template;
        this.error = error;
    }

    CollectionJson() {
        this("1.0", null, Links.NONE, Collections.emptyList(), null, null, null);
    }

    @SafeVarargs
    final CollectionJson<T> withItems(CollectionJsonItem<T> ... items) {
        return this.withItems(Arrays.asList(items));
    }

    CollectionJson<T> withItems(List<CollectionJsonItem<T>> items) {
        return new CollectionJson<T>(this.version, this.href, this.links, items, this.queries, this.template, this.error);
    }

    CollectionJson<T> withLinks(Link ... links) {
        return this.withLinks(Links.of(links));
    }

    CollectionJson<T> withLinks(Links links) {
        return new CollectionJson<T>(this.version, this.href, links, this.items, this.queries, this.template, this.error);
    }

    CollectionJson<T> withOwnSelfLink() {
        String href = this.href;
        if (href == null) {
            return this;
        }
        return this.withLinks(Links.of(new Link(href)).merge(Links.MergeMode.SKIP_BY_REL, this.links));
    }

    boolean hasItems() {
        return !this.items.isEmpty();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionJson)) {
            return false;
        }
        CollectionJson other = (CollectionJson)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$href = this.getHref();
        String other$href = other.getHref();
        if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        List<CollectionJsonItem<T>> this$items = this.getItems();
        List<CollectionJsonItem<T>> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        List<CollectionJsonQuery> this$queries = this.getQueries();
        List<CollectionJsonQuery> other$queries = other.getQueries();
        if (this$queries == null ? other$queries != null : !((Object)this$queries).equals(other$queries)) {
            return false;
        }
        CollectionJsonTemplate this$template = this.getTemplate();
        CollectionJsonTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        CollectionJsonError this$error = this.getError();
        CollectionJsonError other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        List<CollectionJsonItem<T>> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        List<CollectionJsonQuery> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : ((Object)$queries).hashCode());
        CollectionJsonTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        CollectionJsonError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CollectionJson(version=" + this.getVersion() + ", href=" + this.getHref() + ", links=" + this.getLinks() + ", items=" + this.getItems() + ", queries=" + this.getQueries() + ", template=" + this.getTemplate() + ", error=" + this.getError() + ")";
    }

    @JsonProperty
    @Generated
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    @Nullable
    @Generated
    public String getHref() {
        return this.href;
    }

    @JsonProperty
    @Generated
    public Links getLinks() {
        return this.links;
    }

    @JsonProperty
    @Generated
    public List<CollectionJsonItem<T>> getItems() {
        return this.items;
    }

    @JsonProperty
    @Generated
    public List<CollectionJsonQuery> getQueries() {
        return this.queries;
    }

    @JsonProperty
    @Nullable
    @Generated
    public CollectionJsonTemplate getTemplate() {
        return this.template;
    }

    @JsonProperty
    @Nullable
    @Generated
    public CollectionJsonError getError() {
        return this.error;
    }

    @Generated
    CollectionJson<T> withVersion(String version) {
        return this.version == version ? this : new CollectionJson<T>(version, this.href, this.links, this.items, this.queries, this.template, this.error);
    }

    @Generated
    CollectionJson<T> withHref(@Nullable String href) {
        return this.href == href ? this : new CollectionJson<T>(this.version, href, this.links, this.items, this.queries, this.template, this.error);
    }

    @Generated
    CollectionJson<T> withQueries(List<CollectionJsonQuery> queries) {
        return this.queries == queries ? this : new CollectionJson<T>(this.version, this.href, this.links, this.items, queries, this.template, this.error);
    }

    @Generated
    CollectionJson<T> withTemplate(@Nullable CollectionJsonTemplate template) {
        return this.template == template ? this : new CollectionJson<T>(this.version, this.href, this.links, this.items, this.queries, template, this.error);
    }

    @Generated
    CollectionJson<T> withError(@Nullable CollectionJsonError error) {
        return this.error == error ? this : new CollectionJson<T>(this.version, this.href, this.links, this.items, this.queries, this.template, error);
    }
}

