/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HalFormsConfiguration {
    private final HalConfiguration halConfiguration;
    private final Map<Class<?>, String> patterns;
    private final Consumer<ObjectMapper> objectMapperCustomizer;

    public HalFormsConfiguration() {
        this(new HalConfiguration());
    }

    public HalFormsConfiguration(HalConfiguration halConfiguration) {
        this(halConfiguration, new HashMap(), __ -> {});
    }

    private HalFormsConfiguration(HalConfiguration halConfiguration, Map<Class<?>, String> patterns, @Nullable Consumer<ObjectMapper> objectMapperCustomizer) {
        Assert.notNull((Object)halConfiguration, (String)"HalConfiguration must not be null!");
        Assert.notNull(patterns, (String)"Patterns must not be null!");
        Assert.notNull(objectMapperCustomizer, (String)"ObjectMapper customizer must not be null!");
        this.halConfiguration = halConfiguration;
        this.patterns = patterns;
        this.objectMapperCustomizer = objectMapperCustomizer;
    }

    @Deprecated
    public HalFormsConfiguration registerPattern(Class<?> type, String pattern) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.hasText((String)pattern, (String)"Pattern must not be null or empty!");
        this.patterns.put(type, pattern);
        return this;
    }

    @Deprecated
    public HalFormsConfiguration withPattern(Class<?> type, String pattern) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.hasText((String)pattern, (String)"Pattern must not be null or empty!");
        HashMap newPatterns = new HashMap(this.patterns);
        newPatterns.put(type, pattern);
        return new HalFormsConfiguration(this.halConfiguration, newPatterns, this.objectMapperCustomizer);
    }

    public HalFormsConfiguration withObjectMapperCustomizer(Consumer<ObjectMapper> objectMapperCustomizer) {
        Assert.notNull(objectMapperCustomizer, (String)"ObjectMapper customizer must not be null!");
        return this.objectMapperCustomizer == objectMapperCustomizer ? this : new HalFormsConfiguration(this.halConfiguration, this.patterns, objectMapperCustomizer);
    }

    public HalFormsConfiguration customize(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        this.objectMapperCustomizer.accept(mapper);
        return this;
    }

    public HalConfiguration getHalConfiguration() {
        return this.halConfiguration;
    }

    Optional<String> getTypePatternFor(ResolvableType type) {
        return Optional.ofNullable(this.patterns.get(type.resolve(Object.class)));
    }
}

