/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.NonComposite;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.core.AnnotationAttribute;
import org.springframework.hateoas.server.core.DummyInvocationUtils;
import org.springframework.hateoas.server.core.LastInvocationAware;
import org.springframework.hateoas.server.core.MethodInvocation;
import org.springframework.hateoas.server.core.MethodParameters;
import org.springframework.hateoas.server.core.SpringAffordanceBuilder;
import org.springframework.hateoas.server.core.UriTemplateFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class WebHandler {
    private static final TypeDescriptor STRING_DESCRIPTOR = TypeDescriptor.valueOf(String.class);

    public static <T extends LinkBuilder> PreparedWebHandler<T> linkTo(Object invocationValue, LinkBuilderCreator<T> creator) {
        return WebHandler.linkTo(invocationValue, creator, null);
    }

    public static <T extends LinkBuilder> T linkTo(Object invocationValue, LinkBuilderCreator<T> creator, @Nullable BiFunction<UriComponentsBuilder, MethodInvocation, UriComponentsBuilder> additionalUriHandler, Function<String, UriComponentsBuilder> finisher, Supplier<ConversionService> conversionService) {
        return WebHandler.linkTo(invocationValue, creator, additionalUriHandler).conclude(finisher, conversionService.get());
    }

    private static <T extends LinkBuilder> PreparedWebHandler<T> linkTo(Object invocationValue, LinkBuilderCreator<T> creator, @Nullable BiFunction<UriComponentsBuilder, MethodInvocation, UriComponentsBuilder> additionalUriHandler) {
        Assert.isInstanceOf(LastInvocationAware.class, (Object)invocationValue);
        LastInvocationAware invocations = DummyInvocationUtils.getLastInvocationAware(invocationValue);
        if (invocations == null) {
            throw new IllegalStateException(String.format("Could not obtain previous invocation from %s!", invocationValue));
        }
        MethodInvocation invocation = invocations.getLastInvocation();
        String mapping = SpringAffordanceBuilder.getMapping(invocation.getTargetType(), invocation.getMethod());
        return (finisher, conversionService) -> {
            UriComponentsBuilder builder = (UriComponentsBuilder)finisher.apply(mapping);
            UriTemplate template = UriTemplateFactory.templateFor(mapping == null ? "/" : mapping);
            HashMap<Object, Object> values = new HashMap<Object, Object>();
            List variableNames = template.getVariableNames();
            Iterator names = variableNames.iterator();
            Iterator<Object> classMappingParameters = invocations.getObjectParameters();
            while (classMappingParameters.hasNext()) {
                String name = (String)names.next();
                TemplateVariable variable = TemplateVariable.segment(name);
                Object source = classMappingParameters.next();
                values.put(name, variable.prepareAndEncode(HandlerMethodParameter.prepareValue(source, conversionService, TypeDescriptor.forObject((Object)source))));
            }
            Method method = invocation.getMethod();
            HandlerMethodParameters parameters = HandlerMethodParameters.of(method);
            Object[] arguments = invocation.getArguments();
            for (HandlerMethodParameter handlerMethodParameter : parameters.getParameterAnnotatedWith(PathVariable.class, arguments)) {
                Object variable = TemplateVariable.segment(handlerMethodParameter.getVariableName());
                Object verifiedValue = handlerMethodParameter.getVerifiedValue(arguments);
                Object preparedValue = verifiedValue == null ? verifiedValue : handlerMethodParameter.prepareValue(verifiedValue, conversionService);
                values.put(((TemplateVariable)variable).getName(), ((TemplateVariable)variable).prepareAndEncode(preparedValue));
            }
            ArrayList<String> optionalEmptyParameters = new ArrayList<String>();
            for (HandlerMethodParameter parameter : parameters.getParameterAnnotatedWith(RequestParam.class, arguments)) {
                WebHandler.bindRequestParameters(builder, parameter, arguments, conversionService);
                boolean isSkipValue = UriComponents.UriTemplateVariables.SKIP_VALUE.equals(parameter.getVerifiedValue(arguments));
                boolean isMapParameter = Map.class.isAssignableFrom(parameter.parameter.getParameterType());
                if (!isSkipValue || isMapParameter) continue;
                values.put(parameter.getVariableName(), UriComponents.UriTemplateVariables.SKIP_VALUE);
                if (parameter.isRequired()) continue;
                optionalEmptyParameters.add(parameter.getVariableName());
            }
            for (Object variable : variableNames) {
                if (values.containsKey(variable)) continue;
                values.put(variable, UriComponents.UriTemplateVariables.SKIP_VALUE);
            }
            UriComponents uriComponents = additionalUriHandler == null ? builder.buildAndExpand(values) : ((UriComponentsBuilder)additionalUriHandler.apply(builder, invocation)).buildAndExpand(values);
            TemplateVariables variables = TemplateVariables.NONE;
            for (String parameter : optionalEmptyParameters) {
                boolean previousRequestParameter = uriComponents.getQueryParams().isEmpty() && variables.equals(TemplateVariables.NONE);
                TemplateVariable variable = new TemplateVariable(parameter, previousRequestParameter ? TemplateVariable.VariableType.REQUEST_PARAM : TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED);
                variables = variables.concat(variable);
            }
            List<Affordance> affordances = SpringAffordanceBuilder.getAffordances(invocation.getTargetType(), method, uriComponents.toUriString());
            return creator.createBuilder(uriComponents, variables, affordances);
        };
    }

    private static void bindRequestParameters(UriComponentsBuilder builder, HandlerMethodParameter parameter, Object[] arguments, ConversionService conversionService) {
        Object value = parameter.getVerifiedValue(arguments);
        if (value == null) {
            return;
        }
        Class parameterType = parameter.parameter.getParameterType();
        if (value instanceof MultiValueMap) {
            Map requestParams = (Map)parameter.prepareValue(value, conversionService);
            for (Map.Entry entry : requestParams.entrySet()) {
                for (Object element : (List)entry.getValue()) {
                    TemplateVariable variable = TemplateVariable.pathVariable((String)entry.getKey());
                    builder.queryParam((String)entry.getKey(), new Object[]{variable.prepareAndEncode(element)});
                }
            }
            return;
        }
        if (value instanceof Map) {
            Map requestParams = (Map)parameter.prepareValue(value, conversionService);
            for (Map.Entry entry : requestParams.entrySet()) {
                String key = (String)entry.getKey();
                TemplateVariable variable = TemplateVariable.requestParameter(key);
                builder.queryParam(key, new Object[]{variable.prepareAndEncode(entry.getValue())});
            }
            return;
        }
        if (Map.class.isAssignableFrom(parameterType) && UriComponents.UriTemplateVariables.SKIP_VALUE.equals(value)) {
            return;
        }
        String key = parameter.getVariableName();
        TemplateVariable variable = TemplateVariable.requestParameter(key);
        if (value instanceof Collection) {
            Collection collection = (Collection)parameter.prepareValue(value, conversionService);
            if (parameter.isNonComposite()) {
                builder.queryParam(key, new Object[]{variable.prepareAndEncode(collection)});
            } else {
                for (Object element : collection) {
                    if (key == null) continue;
                    builder.queryParam(key, new Object[]{variable.prepareAndEncode(element)});
                }
            }
        } else if (UriComponents.UriTemplateVariables.SKIP_VALUE.equals(value)) {
            if (parameter.isRequired() && key != null) {
                builder.queryParam(key, new Object[]{String.format("{%s}", key)});
            }
        } else if (key != null) {
            builder.queryParam(key, new Object[]{variable.prepareAndEncode(parameter.prepareValue(value, conversionService))});
        }
    }

    private static Function<Object, String> getFormatter(ConversionService conversionService, TypeDescriptor descriptor) {
        return source -> {
            Object result;
            if (String.class.isInstance(source)) {
                return (String)source;
            }
            Object object = conversionService.canConvert(descriptor, STRING_DESCRIPTOR) ? conversionService.convert(source, descriptor, STRING_DESCRIPTOR) : (result = source == null ? null : source.toString());
            if (result == null) {
                throw new IllegalArgumentException(String.format("Conversion of value %s resulted in null!", source));
            }
            return (String)result;
        };
    }

    private static class PathVariableParameter
    extends HandlerMethodParameter {
        public PathVariableParameter(MethodParameter parameter) {
            super(parameter, new AnnotationAttribute(PathVariable.class));
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    }

    private static class RequestParamParameter
    extends HandlerMethodParameter {
        private final MethodParameter parameter;

        public RequestParamParameter(MethodParameter parameter) {
            super(parameter, new AnnotationAttribute(RequestParam.class));
            this.parameter = parameter;
        }

        @Override
        public boolean isRequired() {
            RequestParam annotation = (RequestParam)this.parameter.getParameterAnnotation(RequestParam.class);
            if (this.parameter.isOptional()) {
                return false;
            }
            return annotation != null && annotation.required() && annotation.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }

        @Override
        @Nullable
        public Object getVerifiedValue(Object[] values) {
            Object value = ObjectUtils.unwrapOptional((Object)values[this.parameter.getParameterIndex()]);
            if (value != null) {
                return value;
            }
            if (!this.isRequired() || this.parameter.isOptional()) {
                return UriComponents.UriTemplateVariables.SKIP_VALUE;
            }
            RequestParam annotation = (RequestParam)this.parameter.getParameterAnnotation(RequestParam.class);
            return annotation.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n") ? UriComponents.UriTemplateVariables.SKIP_VALUE : null;
        }
    }

    private static abstract class HandlerMethodParameter {
        private static final Map<Class<? extends Annotation>, Function<MethodParameter, ? extends HandlerMethodParameter>> FACTORY = new HashMap<Class<? extends Annotation>, Function<MethodParameter, ? extends HandlerMethodParameter>>();
        private static final String NO_PARAMETER_NAME = "Could not determine name of parameter %s! Make sure you compile with parameter information or explicitly define a parameter name in %s.";
        private final MethodParameter parameter;
        private final AnnotationAttribute attribute;
        private final TypeDescriptor typeDescriptor;
        private final boolean isNonComposite;
        private String variableName;

        private HandlerMethodParameter(MethodParameter parameter, AnnotationAttribute attribute) {
            this.parameter = parameter;
            this.attribute = attribute;
            int nestingIndex = Optional.class.isAssignableFrom(parameter.getParameterType()) ? 1 : 0;
            this.typeDescriptor = TypeDescriptor.nested((MethodParameter)parameter, (int)nestingIndex);
            this.isNonComposite = parameter.hasParameterAnnotation(NonComposite.class);
            if (this.isNonComposite) {
                Assert.isTrue((boolean)parameter.hasParameterAnnotation(RequestParam.class), (String)"@NonComposite can only be used in combination with @RequestParam!");
                Class parameterType = parameter.getParameterType();
                Assert.isTrue((parameterType.isArray() || Collection.class.isAssignableFrom(parameterType) ? 1 : 0) != 0, (String)"@NonComposite can only be used with collections or arrays!");
            }
        }

        public static HandlerMethodParameter of(MethodParameter parameter, Class<? extends Annotation> type) {
            Function<MethodParameter, ? extends HandlerMethodParameter> function = FACTORY.get(type);
            if (function == null) {
                throw new IllegalArgumentException(String.format("Unsupported annotation type %s!", type.getName()));
            }
            return function.apply(parameter);
        }

        Class<? extends Annotation> getAnnotationType() {
            return this.attribute.getAnnotationType();
        }

        boolean isNonComposite() {
            return this.isNonComposite;
        }

        public String getVariableName() {
            if (this.variableName == null) {
                this.variableName = this.determineVariableName();
            }
            return this.variableName;
        }

        public Object prepareValue(Object value, ConversionService conversionService) {
            Object result = HandlerMethodParameter.prepareValue(value, conversionService, this.typeDescriptor);
            return result == null ? value : result;
        }

        @Nullable
        public static Object prepareValue(@Nullable Object value, ConversionService conversionService, @Nullable TypeDescriptor descriptor) {
            if (descriptor == null || value == null) {
                return value;
            }
            if (Collection.class.isInstance(value = ObjectUtils.unwrapOptional((Object)value))) {
                ArrayList<Object> prepared = new ArrayList<Object>();
                for (Object element : (Collection)value) {
                    TypeDescriptor elementTypeDescriptor = descriptor.elementTypeDescriptor(element);
                    prepared.add(HandlerMethodParameter.prepareValue(element, conversionService, elementTypeDescriptor));
                }
                return prepared;
            }
            if (Map.class.isInstance(value)) {
                LinkedHashMap<Object, Object> prepared = new LinkedHashMap<Object, Object>();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    TypeDescriptor keyTypeDescriptor = descriptor.getMapKeyTypeDescriptor(entry.getKey());
                    TypeDescriptor elementTypeDescriptor = descriptor.elementTypeDescriptor(entry.getValue());
                    prepared.put(HandlerMethodParameter.prepareValue(entry.getKey(), conversionService, keyTypeDescriptor), HandlerMethodParameter.prepareValue(entry.getValue(), conversionService, elementTypeDescriptor));
                }
                return prepared;
            }
            return WebHandler.getFormatter(conversionService, descriptor).apply(value);
        }

        private String determineVariableName() {
            String parameterName;
            if (this.attribute == null) {
                this.variableName = this.parameter.getParameterName();
                return this.variableName;
            }
            Annotation annotation = this.parameter.getParameterAnnotation(this.attribute.getAnnotationType());
            String string = parameterName = annotation != null ? this.attribute.getValueFrom(annotation) : "";
            if (parameterName != null && StringUtils.hasText((String)parameterName)) {
                return parameterName;
            }
            parameterName = this.parameter.getParameterName();
            if (parameterName == null) {
                throw new IllegalStateException(String.format(NO_PARAMETER_NAME, this.parameter, this.attribute.getAnnotationType()));
            }
            return parameterName;
        }

        @Nullable
        public Object getVerifiedValue(Object[] values) {
            return values[this.parameter.getParameterIndex()];
        }

        public abstract boolean isRequired();

        static {
            FACTORY.put(RequestParam.class, RequestParamParameter::new);
            FACTORY.put(PathVariable.class, PathVariableParameter::new);
        }
    }

    private static class HandlerMethodParameters {
        private static final List<Class<? extends Annotation>> ANNOTATIONS = Arrays.asList(RequestParam.class, PathVariable.class);
        private static final Map<Method, HandlerMethodParameters> CACHE = new ConcurrentHashMap<Method, HandlerMethodParameters>();
        private final MultiValueMap<Class<? extends Annotation>, HandlerMethodParameter> byAnnotationCache = new LinkedMultiValueMap();

        private HandlerMethodParameters(MethodParameters parameters) {
            for (Class<? extends Annotation> annotation : ANNOTATIONS) {
                this.byAnnotationCache.putAll((Map)parameters.getParametersWith(annotation).stream().map(it -> HandlerMethodParameter.of(it, annotation)).collect(Collectors.groupingBy(HandlerMethodParameter::getAnnotationType, LinkedMultiValueMap::new, Collectors.toList())));
            }
        }

        public static HandlerMethodParameters of(Method method) {
            return CACHE.computeIfAbsent(method, it -> {
                MethodParameters parameters = MethodParameters.of(it);
                return new HandlerMethodParameters(parameters);
            });
        }

        public List<HandlerMethodParameter> getParameterAnnotatedWith(Class<? extends Annotation> annotation, Object[] arguments) {
            List parameters = (List)this.byAnnotationCache.get(annotation);
            if (parameters == null) {
                return Collections.emptyList();
            }
            ArrayList<HandlerMethodParameter> result = new ArrayList<HandlerMethodParameter>();
            for (HandlerMethodParameter parameter : parameters) {
                if (parameter.getVerifiedValue(arguments) == null) continue;
                result.add(parameter);
            }
            return result;
        }
    }

    public static interface PreparedWebHandler<T extends LinkBuilder> {
        public T conclude(Function<String, UriComponentsBuilder> var1, ConversionService var2);
    }

    public static interface LinkBuilderCreator<T extends LinkBuilder> {
        public T createBuilder(UriComponents var1, TemplateVariables var2, List<Affordance> var3);
    }
}

