/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.alps;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.Objects;
import org.springframework.hateoas.mediatype.alps.Doc;
import org.springframework.hateoas.mediatype.alps.Ext;
import org.springframework.hateoas.mediatype.alps.Type;

@JsonPropertyOrder(value={"id", "href", "name", "type", "doc", "descriptor", "ext"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Descriptor {
    private final String id;
    private final String href;
    private final String name;
    private final Doc doc;
    private final Type type;
    private final Ext ext;
    private final String rt;
    private final List<Descriptor> descriptor;

    @JsonCreator
    private Descriptor(@JsonProperty(value="id") String id, @JsonProperty(value="href") String href, @JsonProperty(value="name") String name, @JsonProperty(value="doc") Doc doc, @JsonProperty(value="type") Type type, @JsonProperty(value="ext") Ext ext, @JsonProperty(value="rt") String rt, @JsonProperty(value="descriptor") List<Descriptor> descriptor) {
        this.id = id;
        this.href = href;
        this.name = name;
        this.doc = doc;
        this.type = type;
        this.ext = ext;
        this.rt = rt;
        this.descriptor = descriptor;
    }

    public static DescriptorBuilder builder() {
        return new DescriptorBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public Type getType() {
        return this.type;
    }

    public Ext getExt() {
        return this.ext;
    }

    public String getRt() {
        return this.rt;
    }

    public List<Descriptor> getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.href, that.href) && Objects.equals(this.name, that.name) && Objects.equals(this.doc, that.doc) && this.type == that.type && Objects.equals(this.ext, that.ext) && Objects.equals(this.rt, that.rt) && Objects.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.href, this.name, this.doc, this.type, this.ext, this.rt, this.descriptor});
    }

    public String toString() {
        return "Descriptor(id=" + this.id + ", href=" + this.href + ", name=" + this.name + ", doc=" + this.doc + ", type=" + (Object)((Object)this.type) + ", ext=" + this.ext + ", rt=" + this.rt + ", descriptor=" + this.descriptor + ")";
    }

    public static class DescriptorBuilder {
        private String id;
        private String href;
        private String name;
        private Doc doc;
        private Type type;
        private Ext ext;
        private String rt;
        private List<Descriptor> descriptor;

        DescriptorBuilder() {
        }

        public DescriptorBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DescriptorBuilder href(String href) {
            this.href = href;
            return this;
        }

        public DescriptorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DescriptorBuilder doc(Doc doc) {
            this.doc = doc;
            return this;
        }

        public DescriptorBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public DescriptorBuilder ext(Ext ext) {
            this.ext = ext;
            return this;
        }

        public DescriptorBuilder rt(String rt) {
            this.rt = rt;
            return this;
        }

        public DescriptorBuilder descriptor(List<Descriptor> descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        public Descriptor build() {
            return new Descriptor(this.id, this.href, this.name, this.doc, this.type, this.ext, this.rt, this.descriptor);
        }

        public String toString() {
            return "Descriptor.DescriptorBuilder(id=" + this.id + ", href=" + this.href + ", name=" + this.name + ", doc=" + this.doc + ", type=" + (Object)((Object)this.type) + ", ext=" + this.ext + ", rt=" + this.rt + ", descriptor=" + this.descriptor + ")";
        }
    }
}

