/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TypeReferences {

    private static final class SyntheticParameterizedType
    implements ParameterizedType,
    Serializable {
        private static final long serialVersionUID = -521679299810654826L;
        private final Type rawType;
        private final Type[] typeArguments;

        SyntheticParameterizedType(Type rawType, Type ... typeArguments) {
            this.rawType = rawType;
            this.typeArguments = typeArguments;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return null;
        }
    }

    private static abstract class SyntheticParameterizedTypeReference<T>
    extends ParameterizedTypeReference<T> {
        private final Type type;

        SyntheticParameterizedTypeReference() {
            Class<?> foo = ((Object)((Object)this)).getClass();
            Type genericSuperclass = foo.getGenericSuperclass();
            ParameterizedType bar = (ParameterizedType)genericSuperclass;
            Type domainType = bar.getActualTypeArguments()[0];
            Class<?> parameterizedTypeReferenceSubclass = SyntheticParameterizedTypeReference.findParameterizedTypeReferenceSubclass(((Object)((Object)this)).getClass());
            Type type = parameterizedTypeReferenceSubclass.getGenericSuperclass();
            Assert.isInstanceOf(ParameterizedType.class, (Object)type);
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Assert.isTrue((parameterizedType.getActualTypeArguments().length == 1 ? 1 : 0) != 0, (String)String.format("Type must have exactly one generic type argument but has %s.", parameterizedType.getActualTypeArguments().length));
            Class resourceType = GenericTypeResolver.resolveType((Type)parameterizedType.getActualTypeArguments()[0], new HashMap());
            this.type = new SyntheticParameterizedType(resourceType, domainType);
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof SyntheticParameterizedTypeReference && this.type.equals(((SyntheticParameterizedTypeReference)((Object)obj)).type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return "SyntheticParameterizedTypeReference<" + this.type + ">";
        }

        private static Class<?> findParameterizedTypeReferenceSubclass(Class<?> child) {
            Class<?> parent = child.getSuperclass();
            if (Object.class.equals(parent)) {
                throw new IllegalStateException("Expected SyntheticParameterizedTypeReference superclass");
            }
            if (SyntheticParameterizedTypeReference.class.equals(parent)) {
                return child;
            }
            return SyntheticParameterizedTypeReference.findParameterizedTypeReferenceSubclass(parent);
        }
    }

    public static class PagedModelType<T>
    extends SyntheticParameterizedTypeReference<PagedModel<T>> {
    }

    public static class CollectionModelType<T>
    extends SyntheticParameterizedTypeReference<CollectionModel<T>> {
    }

    public static class EntityModelType<T>
    extends SyntheticParameterizedTypeReference<EntityModel<T>> {
    }
}

