/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.aot;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class HypermediaTypeAotProcessor
implements BeanRegistrationAotProcessor {
    HypermediaTypeAotProcessor() {
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        EnableHypermediaSupport annotation = (EnableHypermediaSupport)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)registeredBean.getBeanClass(), EnableHypermediaSupport.class);
        if (annotation == null) {
            return null;
        }
        Stream<String> fromConfig = Arrays.stream(annotation.type()).map(EnableHypermediaSupport.HypermediaType::getLocalPackageName);
        Stream<String> mediaTypePackages = Stream.concat(fromConfig, Stream.of("alps", "problem")).map("org.springframework.hateoas.mediatype."::concat);
        List<String> packagesToScan = Stream.concat(Stream.of("org.springframework.hateoas"), mediaTypePackages).toList();
        return packagesToScan.isEmpty() ? null : new MediaTypeReflectionAotContribution(packagesToScan);
    }

    static class MediaTypeReflectionAotContribution
    implements BeanRegistrationAotContribution {
        private static final Logger LOGGER = LoggerFactory.getLogger(MediaTypeReflectionAotContribution.class);
        private final List<String> mediaTypePackage;
        private final Set<String> packagesSeen;

        public MediaTypeReflectionAotContribution(List<String> mediaTypePackage) {
            Assert.notNull(mediaTypePackage, (String)"Media type packages must not be null!");
            this.mediaTypePackage = mediaTypePackage;
            this.packagesSeen = new HashSet<String>();
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            ReflectionHints reflection = generationContext.getRuntimeHints().reflection();
            this.mediaTypePackage.forEach(it -> {
                if (this.packagesSeen.contains(it)) {
                    return;
                }
                this.packagesSeen.add((String)it);
                FullTypeScanner provider = new FullTypeScanner();
                provider.addIncludeFilter(new JacksonAnnotationPresentFilter());
                provider.addIncludeFilter(new JacksonSuperTypeFilter());
                provider.addExcludeFilter(new EnforcedPackageFilter((String)it));
                LOGGER.info("Registering Spring HATEOAS types in {} for reflection.", it);
                provider.findCandidateComponents((String)it).stream().map(BeanDefinition::getBeanClassName).sorted().peek(type -> LOGGER.debug("> {}", type)).map(TypeReference::of).forEach(reference -> reflection.registerType(reference, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS}));
            });
        }
    }

    static class JacksonSuperTypeFilter
    extends TraversingTypeFilter {
        JacksonSuperTypeFilter() {
        }

        @Override
        protected boolean doMatch(MetadataReader reader, MetadataReaderFactory factory) {
            return reader.getClassMetadata().getClassName().startsWith("com.fasterxml.jackson");
        }
    }

    static class JacksonAnnotationPresentFilter
    extends TraversingTypeFilter {
        private static final Predicate<String> IS_JACKSON_ANNOTATION = it -> it.startsWith("com.fasterxml.jackson");

        JacksonAnnotationPresentFilter() {
        }

        @Override
        protected boolean doMatch(MetadataReader reader, MetadataReaderFactory factory) {
            AnnotationMetadata annotationMetadata = reader.getAnnotationMetadata();
            return annotationMetadata.getAnnotationTypes().stream().anyMatch(IS_JACKSON_ANNOTATION) || annotationMetadata.getDeclaredMethods().stream().flatMap(it -> it.getAnnotations().stream()).map(MergedAnnotation::getType).map(Class::getName).anyMatch(IS_JACKSON_ANNOTATION);
        }
    }

    static abstract class TraversingTypeFilter
    implements TypeFilter {
        TraversingTypeFilter() {
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            if (this.doMatch(metadataReader, metadataReaderFactory)) {
                return true;
            }
            ClassMetadata classMetadata = metadataReader.getClassMetadata();
            String superClassName = classMetadata.getSuperClassName();
            if (superClassName != null && !superClassName.startsWith("java") && this.match(metadataReaderFactory.getMetadataReader(superClassName), metadataReaderFactory)) {
                return true;
            }
            for (String names : classMetadata.getInterfaceNames()) {
                MetadataReader reader = metadataReaderFactory.getMetadataReader(names);
                if (!this.match(reader, metadataReaderFactory)) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean doMatch(MetadataReader var1, MetadataReaderFactory var2);
    }

    static class EnforcedPackageFilter
    implements TypeFilter {
        private final String referencePackage;

        public EnforcedPackageFilter(String referencePackage) {
            this.referencePackage = referencePackage;
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            return !this.referencePackage.equals(ClassUtils.getPackageName((String)metadataReader.getClassMetadata().getClassName()));
        }
    }

    static class FullTypeScanner
    extends ClassPathScanningCandidateComponentProvider {
        public FullTypeScanner() {
            super(false);
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return true;
        }
    }
}

