/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.alps;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import org.springframework.hateoas.mediatype.alps.Format;
import org.springframework.util.Assert;

@JsonPropertyOrder(value={"format", "href", "value"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Doc {
    private final String href;
    private final String value;
    private final Format format;

    public Doc(String value, Format format) {
        Assert.hasText((String)value, (String)"Value must not be null or empty!");
        Assert.notNull((Object)((Object)format), (String)"Format must not be null!");
        this.href = null;
        this.value = value;
        this.format = format;
    }

    @JsonCreator
    private Doc(@JsonProperty(value="href") String href, @JsonProperty(value="value") String value, @JsonProperty(value="format") Format format) {
        this.href = href;
        this.value = value;
        this.format = format;
    }

    public static DocBuilder builder() {
        return new DocBuilder();
    }

    public String getHref() {
        return this.href;
    }

    public String getValue() {
        return this.value;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Doc doc = (Doc)o;
        return Objects.equals(this.href, doc.href) && Objects.equals(this.value, doc.value) && this.format == doc.format;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.href, this.value, this.format});
    }

    public String toString() {
        return "Doc(href=" + this.href + ", value=" + this.value + ", format=" + this.format + ")";
    }

    public static class DocBuilder {
        private String href;
        private String value;
        private Format format;

        DocBuilder() {
        }

        public DocBuilder href(String href) {
            this.href = href;
            return this;
        }

        public DocBuilder value(String value) {
            this.value = value;
            return this;
        }

        public DocBuilder format(Format format) {
            this.format = format;
            return this;
        }

        public Doc build() {
            return new Doc(this.href, this.value, this.format);
        }

        public String toString() {
            return "Doc.DocBuilder(href=" + this.href + ", value=" + this.value + ", format=" + this.format + ")";
        }
    }
}

