/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.alps;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;

@JsonPropertyOrder(value={"id", "href", "value"})
@NullUnmarked
public final class Ext {
    private final String id;
    private final String href;
    private final String value;

    @JsonCreator
    private Ext(@JsonProperty(value="id") String id, @JsonProperty(value="href") String href, @JsonProperty(value="value") String value) {
        this.id = id;
        this.href = href;
        this.value = value;
    }

    public static @NonNull ExtBuilder builder() {
        return new ExtBuilder();
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public String getHref() {
        return this.href;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ext ext = (Ext)o;
        return Objects.equals(this.id, ext.id) && Objects.equals(this.href, ext.href) && Objects.equals(this.value, ext.value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.value);
    }

    public String toString() {
        return "Ext(id=" + this.id + ", href=" + this.href + ", value=" + this.value + ")";
    }

    public static class ExtBuilder {
        private String id;
        private String href;
        private String value;

        ExtBuilder() {
        }

        public ExtBuilder id(@NonNull String id) {
            this.id = id;
            return this;
        }

        public ExtBuilder href(@NonNull String href) {
            this.href = href;
            return this;
        }

        public ExtBuilder value(@NonNull String value) {
            this.value = value;
            return this;
        }

        public Ext build() {
            return new Ext(this.id, this.href, this.value);
        }

        public String toString() {
            return "Ext.ExtBuilder(id=" + this.id + ", href=" + this.href + ", value=" + this.value + ")";
        }
    }
}

