/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.support;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.Date;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.util.Assert;

public class S3FileInfo
extends AbstractFileInfo<S3ObjectSummary> {
    private final S3ObjectSummary s3ObjectSummary;

    public S3FileInfo(S3ObjectSummary s3ObjectSummary) {
        Assert.notNull((Object)s3ObjectSummary, (String)"s3ObjectSummary must not be null");
        this.s3ObjectSummary = s3ObjectSummary;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isLink() {
        return false;
    }

    public long getSize() {
        return this.s3ObjectSummary.getSize();
    }

    public long getModified() {
        return this.s3ObjectSummary.getLastModified().getTime();
    }

    public String getFilename() {
        return this.s3ObjectSummary.getKey();
    }

    public String getPermissions() {
        throw new UnsupportedOperationException("Use [AmazonS3.getObjectAcl()] to obtain permissions.");
    }

    public S3ObjectSummary getFileInfo() {
        return this.s3ObjectSummary;
    }

    public String toString() {
        return "FileInfo [isDirectory=" + this.isDirectory() + ", isLink=" + this.isLink() + ", Size=" + this.getSize() + ", ModifiedTime=" + new Date(this.getModified()) + ", Filename=" + this.getFilename() + ", RemoteDirectory=" + this.getRemoteDirectory() + "]";
    }
}

