/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.inbound;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.integration.aws.support.S3FileInfo;
import org.springframework.integration.aws.support.S3Session;
import org.springframework.integration.aws.support.filters.S3PersistentAcceptOnceFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.AbstractRemoteFileStreamingMessageSource;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3StreamingMessageSource
extends AbstractRemoteFileStreamingMessageSource<S3Object> {
    public S3StreamingMessageSource(RemoteFileTemplate<S3Object> template) {
        super(template, null);
    }

    public S3StreamingMessageSource(RemoteFileTemplate<S3Object> template, Comparator<S3Object> comparator) {
        super(template, comparator);
        this.doSetFilter((FileListFilter)new S3PersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "s3StreamingMessageSource"));
    }

    protected List<AbstractFileInfo<S3Object>> asFileInfoList(Collection<S3Object> collection) {
        return collection.stream().map(S3FileInfo::new).collect(Collectors.toList());
    }

    public String getComponentType() {
        return "aws:s3-inbound-streaming-channel-adapter";
    }

    protected AbstractFileInfo<S3Object> poll() {
        AbstractFileInfo file = super.poll();
        if (file != null) {
            S3Session s3Session = (S3Session)this.getRemoteFileTemplate().getSession();
            file.setRemoteDirectory(s3Session.normalizeBucketName(file.getRemoteDirectory()));
        }
        return file;
    }

    protected boolean isDirectory(S3Object file) {
        return false;
    }
}

