/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.aws.support.AwsRequestFailureException;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsResponse;

public abstract class AbstractAwsMessageHandler<H>
extends AbstractMessageProducingHandler {
    protected static final long DEFAULT_SEND_TIMEOUT = 10000L;
    private EvaluationContext evaluationContext;
    private Expression sendTimeoutExpression = new ValueExpression((Object)10000L);
    private HeaderMapper<H> headerMapper;

    public void setSendTimeout(long sendTimeout) {
        this.setSendTimeoutExpression((Expression)new ValueExpression((Object)sendTimeout));
    }

    public void setSendTimeoutExpressionString(String sendTimeoutExpression) {
        this.setSendTimeoutExpression(EXPRESSION_PARSER.parseExpression(sendTimeoutExpression));
    }

    public void setSendTimeoutExpression(Expression sendTimeoutExpression) {
        Assert.notNull((Object)sendTimeoutExpression, (String)"'sendTimeoutExpression' must not be null");
        this.sendTimeoutExpression = sendTimeoutExpression;
    }

    protected Expression getSendTimeoutExpression() {
        return this.sendTimeoutExpression;
    }

    public void setHeaderMapper(HeaderMapper<H> headerMapper) {
        this.doSetHeaderMapper(headerMapper);
    }

    protected final void doSetHeaderMapper(HeaderMapper<H> headerMapper) {
        this.headerMapper = headerMapper;
    }

    protected HeaderMapper<H> getHeaderMapper() {
        return this.headerMapper;
    }

    protected EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected boolean shouldCopyRequestHeaders() {
        return false;
    }

    protected void handleMessageInternal(Message<?> message) {
        AwsRequest request = this.messageToAwsRequest(message);
        CompletionStage resultFuture = this.handleMessageToAws(message, request).handle((response, ex) -> this.handleResponse(message, request, (AwsResponse)response, (Throwable)ex));
        if (this.isAsync()) {
            this.sendOutputs(resultFuture, message);
            return;
        }
        Long sendTimeout = (Long)this.sendTimeoutExpression.getValue(this.evaluationContext, message, Long.class);
        if (sendTimeout == null || sendTimeout < 0L) {
            try {
                ((CompletableFuture)resultFuture).get();
            }
            catch (InterruptedException | ExecutionException ex2) {
                throw new IllegalStateException(ex2);
            }
        }
        try {
            ((CompletableFuture)resultFuture).get(sendTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new MessageTimeoutException(message, "Timeout waiting for response from AmazonKinesis", (Throwable)te);
        }
        catch (InterruptedException | ExecutionException ex3) {
            throw new IllegalStateException(ex3);
        }
    }

    protected Message<?> handleResponse(Message<?> message, AwsRequest request, AwsResponse response, Throwable cause) {
        if (cause != null) {
            throw new AwsRequestFailureException(message, request, cause);
        }
        return this.getMessageBuilderFactory().fromMessage(message).copyHeadersIfAbsent(this.additionalOnSuccessHeaders(request, response)).setHeaderIfAbsent("aws_serviceResult", (Object)response).build();
    }

    protected abstract AwsRequest messageToAwsRequest(Message<?> var1);

    protected abstract CompletableFuture<? extends AwsResponse> handleMessageToAws(Message<?> var1, AwsRequest var2);

    @Nullable
    protected abstract Map<String, ?> additionalOnSuccessHeaders(AwsRequest var1, AwsResponse var2);
}

