/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.utils.IoUtils;

public class S3Session
implements Session<S3Object> {
    private final S3Client amazonS3;
    private String endpoint;

    public S3Session(S3Client amazonS3) {
        Assert.notNull((Object)amazonS3, (String)"'amazonS3' must not be null.");
        this.amazonS3 = amazonS3;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public S3Object[] list(String path) {
        ListObjectsResponse objectListing;
        String[] bucketPrefix = this.splitPathToBucketAndKey(path, false);
        ListObjectsRequest.Builder listObjectsRequest = ListObjectsRequest.builder().bucket(bucketPrefix[0]);
        if (bucketPrefix.length > 1) {
            listObjectsRequest.prefix(bucketPrefix[1]);
        }
        ArrayList objectSummaries = new ArrayList();
        do {
            objectListing = this.amazonS3.listObjects((ListObjectsRequest)listObjectsRequest.build());
            objectSummaries.addAll(objectListing.contents());
            listObjectsRequest.marker(objectListing.nextMarker());
        } while (objectListing.isTruncated().booleanValue());
        return objectSummaries.toArray(new S3Object[0]);
    }

    public String[] listNames(String path) {
        ListObjectsResponse objectListing;
        String[] bucketPrefix = this.splitPathToBucketAndKey(path, false);
        ListObjectsRequest.Builder listObjectsRequest = ListObjectsRequest.builder().bucket(bucketPrefix[0]);
        if (bucketPrefix.length > 1) {
            listObjectsRequest.prefix(bucketPrefix[1]);
        }
        ArrayList<String> names = new ArrayList<String>();
        do {
            objectListing = this.amazonS3.listObjects((ListObjectsRequest)listObjectsRequest.build());
            for (S3Object objectSummary : objectListing.contents()) {
                names.add(objectSummary.key());
            }
            listObjectsRequest.marker(objectListing.nextMarker());
        } while (objectListing.isTruncated().booleanValue());
        return names.toArray(new String[0]);
    }

    public boolean remove(String path) {
        String[] bucketKey = this.splitPathToBucketAndKey(path, true);
        this.amazonS3.deleteObject(request -> request.bucket(bucketKey[0]).key(bucketKey[1]));
        return true;
    }

    public void rename(String pathFrom, String pathTo) {
        String[] bucketKeyFrom = this.splitPathToBucketAndKey(pathFrom, true);
        String[] bucketKeyTo = this.splitPathToBucketAndKey(pathTo, true);
        CopyObjectRequest.Builder copyRequest = CopyObjectRequest.builder().sourceBucket(bucketKeyFrom[0]).sourceKey(bucketKeyFrom[1]).destinationBucket(bucketKeyTo[0]).destinationKey(bucketKeyTo[1]);
        this.amazonS3.copyObject((CopyObjectRequest)copyRequest.build());
        this.amazonS3.deleteObject(request -> request.bucket(bucketKeyFrom[0]).key(bucketKeyFrom[1]));
    }

    public void read(String source, OutputStream outputStream) throws IOException {
        String[] bucketKey = this.splitPathToBucketAndKey(source, true);
        GetObjectRequest.Builder getObjectRequest = GetObjectRequest.builder().bucket(bucketKey[0]).key(bucketKey[1]);
        try (ResponseInputStream inputStream = this.amazonS3.getObject((GetObjectRequest)getObjectRequest.build());){
            StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    public void write(InputStream inputStream, String destination) {
        Assert.notNull((Object)inputStream, (String)"'inputStream' must not be null.");
        String[] bucketKey = this.splitPathToBucketAndKey(destination, true);
        PutObjectRequest.Builder putObjectRequest = PutObjectRequest.builder().bucket(bucketKey[0]).key(bucketKey[1]);
        try {
            this.amazonS3.putObject((PutObjectRequest)putObjectRequest.build(), RequestBody.fromBytes((byte[])IoUtils.toByteArray((InputStream)inputStream)));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void append(InputStream inputStream, String destination) {
        throw new UnsupportedOperationException("The 'append' operation isn't supported by the Amazon S3 protocol.");
    }

    public boolean mkdir(String directory) {
        this.amazonS3.createBucket(request -> request.bucket(directory));
        return true;
    }

    public boolean rmdir(String directory) {
        this.amazonS3.deleteBucket(request -> request.bucket(directory));
        return true;
    }

    public boolean exists(String path) {
        String[] bucketKey = this.splitPathToBucketAndKey(path, true);
        try {
            this.amazonS3.getObjectAttributes(request -> request.bucket(bucketKey[0]).key(bucketKey[1]));
        }
        catch (NoSuchKeyException ex) {
            return false;
        }
        return true;
    }

    public InputStream readRaw(String source) {
        String[] bucketKey = this.splitPathToBucketAndKey(source, true);
        return this.amazonS3.getObject(request -> request.bucket(bucketKey[0]).key(bucketKey[1]));
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public boolean finalizeRaw() {
        return true;
    }

    public Object getClientInstance() {
        return this.amazonS3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHostPort() {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        S3Session s3Session = this;
        synchronized (s3Session) {
            if (this.endpoint != null) {
                return this.endpoint;
            }
            DirectFieldAccessor dfa = new DirectFieldAccessor((Object)this.amazonS3.utilities());
            Region region = (Region)dfa.getPropertyValue("region");
            this.endpoint = String.format("%s.%s:%d", "s3", region, 443);
            return this.endpoint;
        }
    }

    public String normalizeBucketName(String path) {
        return this.splitPathToBucketAndKey(path, false)[0];
    }

    private String[] splitPathToBucketAndKey(String path, boolean requireKey) {
        Assert.hasText((String)path, (String)"'path' must not be empty String.");
        path = StringUtils.trimLeadingCharacter((String)path, (char)'/');
        String[] bucketKey = path.split("/", 2);
        if (requireKey) {
            Assert.state((bucketKey.length == 2 ? 1 : 0) != 0, (String)"'path' must in pattern [BUCKET/KEY].");
            Assert.state((bucketKey[0].length() >= 3 ? 1 : 0) != 0, (String)"S3 bucket name must be at least 3 characters long.");
        } else {
            Assert.state((bucketKey.length > 0 && bucketKey[0].length() >= 3 ? 1 : 0) != 0, (String)"S3 bucket name must be at least 3 characters long.");
        }
        return bucketKey;
    }
}

