/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.support;

import org.springframework.integration.aws.support.S3Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SharedSessionCapable;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3SessionFactory
implements SessionFactory<S3Object>,
SharedSessionCapable {
    private final S3Session s3Session;

    public S3SessionFactory() {
        this(S3Client.create());
    }

    public S3SessionFactory(S3Client amazonS3) {
        Assert.notNull((Object)amazonS3, (String)"'amazonS3' must not be null.");
        this.s3Session = new S3Session(amazonS3);
    }

    public S3Session getSession() {
        return this.s3Session;
    }

    public boolean isSharedSession() {
        return true;
    }

    public void resetSharedSession() {
    }

    public void setEndpoint(String endpoint) {
        this.s3Session.setEndpoint(endpoint);
    }
}

