/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.springframework.integration.MessagingException;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileLocker;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDirectoryScanner
implements DirectoryScanner {
    private volatile FileListFilter<File> filter = new AcceptOnceFileListFilter<File>();
    private volatile FileLocker locker;

    @Override
    public void setFilter(FileListFilter<File> filter) {
        this.filter = filter;
    }

    @Override
    public final void setLocker(FileLocker locker) {
        this.locker = locker;
    }

    @Override
    public final boolean tryClaim(File file) {
        return this.locker == null || this.locker.lock(file);
    }

    @Override
    public final List<File> listFiles(File directory) throws IllegalArgumentException {
        File[] files = this.listEligibleFiles(directory);
        if (files == null) {
            throw new MessagingException("The path [" + directory + "] does not denote a properly accessible directory.");
        }
        return this.filter != null ? this.filter.filterFiles((File[])files) : Arrays.asList(files);
    }

    protected File[] listEligibleFiles(File directory) {
        return directory.listFiles();
    }
}

