/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.integration.file.filters.AbstractFileListFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptOnceFileListFilter<F>
extends AbstractFileListFilter<F> {
    private final Queue<F> seen;
    private final Object monitor = new Object();

    public AcceptOnceFileListFilter(int maxCapacity) {
        this.seen = new LinkedBlockingQueue<F>(maxCapacity);
    }

    public AcceptOnceFileListFilter() {
        this.seen = new LinkedBlockingQueue<F>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(F file) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.seen.contains(file)) {
                return false;
            }
            if (!this.seen.offer(file)) {
                this.seen.poll();
                this.seen.add(file);
            }
            return true;
        }
    }
}

