/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.file.remote.session.SessionFactoryFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractRemoteFileOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getGatewayClassName());
        BeanDefinitionBuilder sessionFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(SessionFactoryFactoryBean.class);
        sessionFactoryBuilder.addConstructorArgReference(element.getAttribute("session-factory"));
        sessionFactoryBuilder.addConstructorArgValue((Object)element.getAttribute("cache-sessions"));
        builder.addConstructorArgValue((Object)sessionFactoryBuilder.getBeanDefinition());
        builder.addConstructorArgValue((Object)element.getAttribute("command"));
        builder.addConstructorArgValue((Object)element.getAttribute("expression"));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"command-options", (String)"options");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"temporary-file-suffix");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        this.configureFilter(builder, element, parserContext);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"remote-file-separator");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"local-directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-create-local-directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"order");
        return builder;
    }

    protected void configureFilter(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        String filter = element.getAttribute("filter");
        String fileNamePattern = element.getAttribute("filename-pattern");
        String fileNameRegex = element.getAttribute("filename-regex");
        boolean hasFilter = StringUtils.hasText((String)filter);
        boolean hasFileNamePattern = StringUtils.hasText((String)fileNamePattern);
        boolean hasFileNameRegex = StringUtils.hasText((String)fileNameRegex);
        int count = hasFilter ? 1 : 0;
        count += hasFileNamePattern ? 1 : 0;
        if ((count += hasFileNameRegex ? 1 : 0) > 1) {
            parserContext.getReaderContext().error("at most one of 'filename-pattern', 'filename-regex', or 'filter' is allowed on remote file inbound adapter", (Object)element);
        } else if (hasFilter) {
            builder.addPropertyReference("filter", filter);
        } else if (hasFileNamePattern) {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getSimplePatternFileListFilterClassname());
            filterBuilder.addConstructorArgValue((Object)fileNamePattern);
            builder.addPropertyValue("filter", (Object)filterBuilder.getBeanDefinition());
        } else if (hasFileNameRegex) {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getRegexPatternFileListFilterClassname());
            filterBuilder.addConstructorArgValue((Object)fileNameRegex);
            builder.addPropertyValue("filter", (Object)filterBuilder.getBeanDefinition());
        }
    }

    protected abstract String getRegexPatternFileListFilterClassname();

    protected abstract String getSimplePatternFileListFilterClassname();

    protected abstract String getGatewayClassName();
}

