/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.remote.handler.FileTransferringMessageHandler;
import org.springframework.integration.file.remote.session.SessionFactoryFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RemoteFileOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder handlerBuilder = BeanDefinitionBuilder.genericBeanDefinition(FileTransferringMessageHandler.class);
        BeanDefinitionBuilder sessionFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(SessionFactoryFactoryBean.class);
        sessionFactoryBuilder.addConstructorArgReference(element.getAttribute("session-factory"));
        sessionFactoryBuilder.addConstructorArgValue((Object)element.getAttribute("cache-sessions"));
        handlerBuilder.addConstructorArgValue((Object)sessionFactoryBuilder.getBeanDefinition());
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)handlerBuilder, (Element)element, (String)"temporary-file-suffix");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)handlerBuilder, (Element)element, (String)"use-temporary-file-name");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)handlerBuilder, (Element)element, (String)"auto-create-directory");
        this.configureRemoteDirectories(element, handlerBuilder);
        String remoteFileNameGenerator = element.getAttribute("remote-filename-generator");
        String remoteFileNameGeneratorExpression = element.getAttribute("remote-filename-generator-expression");
        boolean hasRemoteFileNameGenerator = StringUtils.hasText((String)remoteFileNameGenerator);
        boolean hasRemoteFileNameGeneratorExpression = StringUtils.hasText((String)remoteFileNameGeneratorExpression);
        if (hasRemoteFileNameGenerator || hasRemoteFileNameGeneratorExpression) {
            if (hasRemoteFileNameGenerator && hasRemoteFileNameGeneratorExpression) {
                throw new BeanDefinitionStoreException("at most one of 'remote-filename-generator-expression' or 'remote-filename-generator' is allowed on a remote file outbound adapter");
            }
            if (hasRemoteFileNameGenerator) {
                handlerBuilder.addPropertyReference("fileNameGenerator", remoteFileNameGenerator);
            } else {
                BeanDefinitionBuilder fileNameGeneratorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultFileNameGenerator.class);
                fileNameGeneratorBuilder.addPropertyValue("expression", (Object)remoteFileNameGeneratorExpression);
                handlerBuilder.addPropertyValue("fileNameGenerator", (Object)fileNameGeneratorBuilder.getBeanDefinition());
            }
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)handlerBuilder, (Element)element, (String)"charset");
        handlerBuilder.addPropertyValue("remoteFileSeparator", (Object)element.getAttribute("remote-file-separator"));
        return handlerBuilder.getBeanDefinition();
    }

    private void configureRemoteDirectories(Element element, BeanDefinitionBuilder handlerBuilder) {
        this.doConfigureRemoteDirectory(element, handlerBuilder, "remote-directory", "remote-directory-expression", "remoteDirectoryExpression", true);
        this.doConfigureRemoteDirectory(element, handlerBuilder, "temporary-remote-directory", "temporary-remote-directory-expression", "temporaryRemoteDirectoryExpression", false);
    }

    private void doConfigureRemoteDirectory(Element element, BeanDefinitionBuilder handlerBuilder, String directoryAttribute, String directoryExpressionAttribute, String directoryExpressionPropertyName, boolean atLeastOneRequired) {
        String remoteDirectory = element.getAttribute(directoryAttribute);
        String remoteDirectoryExpression = element.getAttribute(directoryExpressionAttribute);
        boolean hasRemoteDirectory = StringUtils.hasText((String)remoteDirectory);
        boolean hasRemoteDirectoryExpression = StringUtils.hasText((String)remoteDirectoryExpression);
        if (atLeastOneRequired && !(hasRemoteDirectory ^ hasRemoteDirectoryExpression)) {
            throw new BeanDefinitionStoreException("exactly one of '" + directoryAttribute + "' or '" + directoryExpressionAttribute + "' " + "is required on a remote file outbound adapter");
        }
        RootBeanDefinition remoteDirectoryExpressionDefinition = null;
        if (hasRemoteDirectory) {
            remoteDirectoryExpressionDefinition = new RootBeanDefinition(LiteralExpression.class);
            remoteDirectoryExpressionDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)remoteDirectory);
        } else if (hasRemoteDirectoryExpression) {
            remoteDirectoryExpressionDefinition = new RootBeanDefinition(ExpressionFactoryBean.class);
            remoteDirectoryExpressionDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)remoteDirectoryExpression);
        }
        if (remoteDirectoryExpressionDefinition != null) {
            handlerBuilder.addPropertyValue(directoryExpressionPropertyName, (Object)remoteDirectoryExpressionDefinition);
        }
    }
}

