/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.transformer;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.transformer.Transformer;
import org.springframework.util.Assert;

public abstract class AbstractFilePayloadTransformer<T>
implements Transformer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile boolean deleteFiles;

    public void setDeleteFiles(boolean deleteFiles) {
        this.deleteFiles = deleteFiles;
    }

    public final Message<?> transform(Message<?> message) {
        try {
            Assert.notNull(message, (String)"Message must not be null");
            Object payload = message.getPayload();
            Assert.notNull((Object)payload, (String)"Mesasge payload must not be null");
            Assert.isInstanceOf(File.class, (Object)payload, (String)"Message payload must be of type [java.io.File]");
            File file = (File)payload;
            T result = this.transformFile(file);
            Message transformedMessage = MessageBuilder.withPayload(result).copyHeaders((Map)message.getHeaders()).setHeaderIfAbsent("file_originalFile", (Object)file).setHeaderIfAbsent("file_name", (Object)file.getName()).build();
            if (this.deleteFiles && !file.delete() && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("failed to delete File '" + file + "'"));
            }
            return transformedMessage;
        }
        catch (Exception e) {
            throw new MessagingException(message, "failed to transform File Message", (Throwable)e);
        }
    }

    protected abstract T transformFile(File var1) throws Exception;
}

