/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.integration.file.filters.FileListFilter;

public class LastModifiedFileListFilter
implements FileListFilter<File> {
    private static final long DEFAULT_AGE = 60L;
    private volatile long age = 60L;

    public long getAge() {
        return this.age;
    }

    public void setAge(long age) {
        this.setAge(age, TimeUnit.SECONDS);
    }

    public void setAge(long age, TimeUnit unit) {
        this.age = unit.toSeconds(age);
    }

    public List<File> filterFiles(File[] files) {
        ArrayList<File> list = new ArrayList<File>();
        long now = System.currentTimeMillis() / 1000L;
        for (File file : files) {
            if (file.lastModified() / 1000L + this.age > now) continue;
            list.add(file);
        }
        return list;
    }
}

