/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.List;
import org.springframework.integration.file.filters.AbstractFileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.util.Assert;

public abstract class AbstractPersistentAcceptOnceFileListFilter<F>
extends AbstractFileListFilter<F>
implements ReversibleFileListFilter<F>,
ResettableFileListFilter<F>,
Closeable {
    protected final ConcurrentMetadataStore store;
    protected final Flushable flushableStore;
    protected final String prefix;
    protected volatile boolean flushOnUpdate;
    private final Object monitor = new Object();

    public AbstractPersistentAcceptOnceFileListFilter(ConcurrentMetadataStore store, String prefix) {
        Assert.notNull((Object)store, (String)"'store' cannot be null");
        Assert.notNull((Object)prefix, (String)"'prefix' cannot be null");
        this.store = store;
        this.prefix = prefix;
        this.flushableStore = store instanceof Flushable ? (Flushable)store : null;
    }

    public void setFlushOnUpdate(boolean flushOnUpdate) {
        this.flushOnUpdate = flushOnUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(F file) {
        String key = this.buildKey(file);
        Object object = this.monitor;
        synchronized (object) {
            String newValue = this.value(file);
            String oldValue = this.store.putIfAbsent(key, newValue);
            if (oldValue == null) {
                this.flushIfNeeded();
                return this.fileStillExists(file);
            }
            if (!this.isEqual(file, oldValue) && this.store.replace(key, oldValue, newValue)) {
                this.flushIfNeeded();
                return this.fileStillExists(file);
            }
            return false;
        }
    }

    protected boolean fileStillExists(F file) {
        return true;
    }

    @Override
    public void rollback(F file, List<F> files) {
        boolean rollingBack = false;
        for (F fileToRollback : files) {
            if (fileToRollback.equals(file)) {
                rollingBack = true;
            }
            if (!rollingBack) continue;
            this.remove(fileToRollback);
        }
    }

    @Override
    public boolean remove(F fileToRemove) {
        String removed = this.store.remove(this.buildKey(fileToRemove));
        this.flushIfNeeded();
        return removed != null;
    }

    @Override
    public void close() throws IOException {
        if (this.store instanceof Closeable) {
            ((Closeable)this.store).close();
        }
    }

    private String value(F file) {
        return Long.toString(this.modified(file));
    }

    protected boolean isEqual(F file, String value) {
        return Long.valueOf(value).longValue() == this.modified(file);
    }

    protected String buildKey(F file) {
        return this.prefix + this.fileName(file);
    }

    protected void flushIfNeeded() {
        if (this.flushOnUpdate && this.flushableStore != null) {
            try {
                this.flushableStore.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected abstract long modified(F var1);

    protected abstract String fileName(F var1);
}

