/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.file.remote.session.DelegatingSessionFactory;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SharedSessionCapable;
import org.springframework.integration.util.SimplePool;
import org.springframework.util.Assert;

public class CachingSessionFactory<F>
implements SessionFactory<F>,
DisposableBean {
    private static final Log logger = LogFactory.getLog(CachingSessionFactory.class);
    private final SessionFactory<F> sessionFactory;
    private final SimplePool<Session<F>> pool;
    private final boolean isSharedSessionCapable;
    private volatile long sharedSessionEpoch;

    public CachingSessionFactory(SessionFactory<F> sessionFactory) {
        this(sessionFactory, 0);
    }

    public CachingSessionFactory(SessionFactory<F> sessionFactory, int sessionCacheSize) {
        Assert.isTrue((!(sessionFactory instanceof DelegatingSessionFactory) ? 1 : 0) != 0, (String)"'sessionFactory' cannot be a 'DelegatingSessionFactory'; cache each delegate instead");
        this.sessionFactory = sessionFactory;
        this.pool = new SimplePool(sessionCacheSize, new SimplePool.PoolItemCallback<Session<F>>(){

            public Session<F> createForPool() {
                return CachingSessionFactory.this.sessionFactory.getSession();
            }

            public boolean isStale(Session<F> session) {
                return !session.isOpen();
            }

            public void removedFromPool(Session<F> session) {
                session.close();
            }
        });
        this.isSharedSessionCapable = sessionFactory instanceof SharedSessionCapable;
    }

    public void setSessionWaitTimeout(long sessionWaitTimeout) {
        this.pool.setWaitTimeout(sessionWaitTimeout);
    }

    public void setPoolSize(int poolSize) {
        this.pool.setPoolSize(poolSize);
    }

    @Override
    public Session<F> getSession() {
        return new CachedSession((Session)this.pool.getItem(), this.sharedSessionEpoch);
    }

    public void destroy() {
        this.pool.removeAllIdleItems();
    }

    public synchronized void resetCache() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Cache reset; idle sessions will be removed, in-use sessions will be closed when returned");
        }
        if (this.isSharedSessionCapable && ((SharedSessionCapable)((Object)this.sessionFactory)).isSharedSession()) {
            ((SharedSessionCapable)((Object)this.sessionFactory)).resetSharedSession();
        }
        long sharedSessionEpoch = System.nanoTime();
        while (sharedSessionEpoch == this.sharedSessionEpoch) {
            sharedSessionEpoch = System.nanoTime();
        }
        this.sharedSessionEpoch = sharedSessionEpoch;
        this.pool.removeAllIdleItems();
    }

    public class CachedSession
    implements Session<F> {
        private final Session<F> targetSession;
        private boolean released;
        private boolean dirty;
        private final long sharedSessionEpoch;

        private CachedSession(Session<F> targetSession, long sharedSessionEpoch) {
            this.targetSession = targetSession;
            this.sharedSessionEpoch = sharedSessionEpoch;
        }

        @Override
        public synchronized void close() {
            if (this.released) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Session " + this.targetSession + " already released."));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Releasing Session " + this.targetSession + " back to the pool."));
                }
                if (this.sharedSessionEpoch != CachingSessionFactory.this.sharedSessionEpoch) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Closing session " + this.targetSession + " after reset."));
                    }
                    this.targetSession.close();
                } else if (this.dirty) {
                    this.targetSession.close();
                }
                if (this.targetSession.isOpen()) {
                    try {
                        this.targetSession.finalizeRaw();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                CachingSessionFactory.this.pool.releaseItem(this.targetSession);
                this.released = true;
            }
        }

        @Override
        public boolean remove(String path) throws IOException {
            return this.targetSession.remove(path);
        }

        @Override
        public F[] list(String path) throws IOException {
            return this.targetSession.list(path);
        }

        @Override
        public void read(String source, OutputStream os) throws IOException {
            this.targetSession.read(source, os);
        }

        @Override
        public void write(InputStream inputStream, String destination) throws IOException {
            this.targetSession.write(inputStream, destination);
        }

        @Override
        public void append(InputStream inputStream, String destination) throws IOException {
            this.targetSession.append(inputStream, destination);
        }

        @Override
        public boolean isOpen() {
            return this.targetSession.isOpen();
        }

        @Override
        public void rename(String pathFrom, String pathTo) throws IOException {
            this.targetSession.rename(pathFrom, pathTo);
        }

        @Override
        public boolean mkdir(String directory) throws IOException {
            return this.targetSession.mkdir(directory);
        }

        @Override
        public boolean rmdir(String directory) throws IOException {
            return this.targetSession.rmdir(directory);
        }

        @Override
        public boolean exists(String path) throws IOException {
            return this.targetSession.exists(path);
        }

        @Override
        public String[] listNames(String path) throws IOException {
            return this.targetSession.listNames(path);
        }

        @Override
        public InputStream readRaw(String source) throws IOException {
            return this.targetSession.readRaw(source);
        }

        @Override
        public boolean finalizeRaw() throws IOException {
            return this.targetSession.finalizeRaw();
        }

        public void dirty() {
            this.dirty = true;
        }

        @Override
        public Object getClientInstance() {
            return this.targetSession.getClientInstance();
        }
    }
}

