/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.endpoint.AbstractFetchLimitingMessageSource;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public abstract class AbstractRemoteFileStreamingMessageSource<F>
extends AbstractFetchLimitingMessageSource<InputStream>
implements BeanFactoryAware,
InitializingBean {
    private final RemoteFileTemplate<F> remoteFileTemplate;
    private final BlockingQueue<AbstractFileInfo<F>> toBeReceived = new LinkedBlockingQueue<AbstractFileInfo<F>>();
    private final Comparator<AbstractFileInfo<F>> comparator;
    private boolean fileInfoJson = true;
    private volatile Expression remoteDirectoryExpression;
    private volatile String remoteFileSeparator = "/";
    private volatile FileListFilter<F> filter;

    protected AbstractRemoteFileStreamingMessageSource(RemoteFileTemplate<F> template, Comparator<AbstractFileInfo<F>> comparator) {
        this.remoteFileTemplate = template;
        this.comparator = comparator;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectoryExpression = new LiteralExpression(remoteDirectory);
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        Assert.notNull((Object)remoteDirectoryExpression, (String)"'remoteDirectoryExpression' must not be null");
        this.remoteDirectoryExpression = remoteDirectoryExpression;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        Assert.notNull((Object)remoteFileSeparator, (String)"'remoteFileSeparator' must not be null");
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public void setFilter(FileListFilter<F> filter) {
        this.doSetFilter(filter);
    }

    protected final void doSetFilter(FileListFilter<F> filter) {
        this.filter = filter;
    }

    public void setFileInfoJson(boolean fileInfoJson) {
        this.fileInfoJson = fileInfoJson;
    }

    protected RemoteFileTemplate<F> getRemoteFileTemplate() {
        return this.remoteFileTemplate;
    }

    public final void afterPropertiesSet() {
        Assert.state((this.remoteDirectoryExpression != null ? 1 : 0) != 0, (String)"'remoteDirectoryExpression' must not be null");
        this.doInit();
    }

    protected void doInit() {
    }

    protected Object doReceive() {
        AbstractFileInfo<F> file = this.poll();
        if (file != null) {
            String remotePath = this.remotePath(file);
            Session<F> session = this.remoteFileTemplate.getSession();
            try {
                return this.getMessageBuilderFactory().withPayload((Object)session.readRaw(remotePath)).setHeader("closeableResource", session).setHeader("file_remoteDirectory", (Object)file.getRemoteDirectory()).setHeader("file_remoteFile", (Object)file.getFilename()).setHeader("file_remoteFileInfo", this.fileInfoJson ? file.toJson() : file);
            }
            catch (IOException e) {
                throw new MessagingException("IOException when retrieving " + remotePath, (Throwable)e);
            }
        }
        return null;
    }

    protected Object doReceive(int maxFetchSize) {
        return this.doReceive();
    }

    protected AbstractFileInfo<F> poll() {
        if (this.toBeReceived.size() == 0) {
            this.listFiles();
        }
        return (AbstractFileInfo)this.toBeReceived.poll();
    }

    protected String remotePath(AbstractFileInfo<F> file) {
        String remotePath = file.getRemoteDirectory().endsWith(this.remoteFileSeparator) ? file.getRemoteDirectory() + file.getFilename() : file.getRemoteDirectory() + this.remoteFileSeparator + file.getFilename();
        return remotePath;
    }

    private void listFiles() {
        List<F> filteredFiles;
        String remoteDirectory = (String)this.remoteDirectoryExpression.getValue((EvaluationContext)this.getEvaluationContext(), String.class);
        F[] files = this.remoteFileTemplate.list(remoteDirectory);
        int maxFetchSize = this.getMaxFetchSize();
        List<F> list = filteredFiles = this.filter == null ? Arrays.asList(files) : this.filter.filterFiles(files);
        if (maxFetchSize > 0 && filteredFiles.size() > maxFetchSize) {
            this.rollbackFromFileToListEnd(filteredFiles, filteredFiles.get(maxFetchSize));
            ArrayList<F> newList = new ArrayList<F>(maxFetchSize);
            for (int i = 0; i < maxFetchSize; ++i) {
                newList.add(filteredFiles.get(i));
            }
            filteredFiles = newList;
        }
        List<AbstractFileInfo<F>> fileInfoList = this.asFileInfoList(filteredFiles);
        Iterator<AbstractFileInfo<F>> iterator = fileInfoList.iterator();
        while (iterator.hasNext()) {
            AbstractFileInfo<F> next = iterator.next();
            if (next.isDirectory()) {
                iterator.remove();
                continue;
            }
            next.setRemoteDirectory(remoteDirectory);
        }
        if (this.comparator != null) {
            Collections.sort(fileInfoList, this.comparator);
        }
        this.toBeReceived.addAll(fileInfoList);
    }

    protected void rollbackFromFileToListEnd(List<F> filteredFiles, F file) {
        if (this.filter instanceof ReversibleFileListFilter) {
            ((ReversibleFileListFilter)this.filter).rollback(file, filteredFiles);
        }
    }

    protected abstract List<AbstractFileInfo<F>> asFileInfoList(Collection<F> var1);
}

