/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.tail;

import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.springframework.integration.file.tail.FileTailingMessageProducerSupport;

public class ApacheCommonsFileTailingMessageProducer
extends FileTailingMessageProducerSupport
implements TailerListener {
    private volatile Tailer tailer;
    private volatile long pollingDelay = 1000L;
    private volatile boolean end = true;
    private volatile boolean reopen = false;

    public void setPollingDelay(long pollingDelay) {
        this.pollingDelay = pollingDelay;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public void setReopen(boolean reopen) {
        this.reopen = reopen;
    }

    @Override
    public String getComponentType() {
        return super.getComponentType() + " (Apache)";
    }

    @Override
    protected void doStart() {
        super.doStart();
        Tailer theTailer = new Tailer(this.getFile(), (TailerListener)this, this.pollingDelay, this.end, this.reopen);
        this.getTaskExecutor().execute((Runnable)theTailer);
        this.tailer = theTailer;
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.tailer.stop();
    }

    public void init(Tailer tailer) {
    }

    public void fileNotFound() {
        this.publish("File not found: " + this.getFile().getAbsolutePath());
        try {
            Thread.sleep(this.getMissingFileDelay());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void fileRotated() {
        this.publish("File rotated: " + this.getFile().getAbsolutePath());
    }

    public void handle(String line) {
        this.send(line);
    }

    public void handle(Exception ex) {
        this.publish(ex.getMessage());
    }
}

