/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.gateway;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.MessageSessionCallback;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.RemoteFileUtils;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.support.MutableMessage;
import org.springframework.integration.support.PartialSuccessException;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractRemoteFileOutboundGateway<F>
extends AbstractReplyProducingMessageHandler {
    private final RemoteFileTemplate<F> remoteFileTemplate;
    private final Command command;
    private final Set<Option> options = new HashSet<Option>();
    private final ExpressionEvaluatingMessageProcessor<String> fileNameProcessor;
    private final MessageSessionCallback<F, ?> messageSessionCallback;
    private ExpressionEvaluatingMessageProcessor<String> renameProcessor = new ExpressionEvaluatingMessageProcessor((Expression)new FunctionExpression(m -> m.getHeaders().get((Object)"file_renameTo")));
    private Expression localDirectoryExpression;
    private boolean autoCreateLocalDirectory = true;
    private FileListFilter<F> filter;
    private boolean filterAfterEnhancement;
    private FileListFilter<File> mputFilter;
    private Expression localFilenameGeneratorExpression;
    private FileExistsMode fileExistsMode;
    private Integer chmod;
    private boolean remoteFileTemplateExplicitlySet;

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, MessageSessionCallback<F, ?> messageSessionCallback) {
        this(new RemoteFileTemplate<F>(sessionFactory), messageSessionCallback);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, MessageSessionCallback<F, ?> messageSessionCallback) {
        Assert.notNull(remoteFileTemplate, (String)"'remoteFileTemplate' cannot be null");
        Assert.notNull(messageSessionCallback, (String)"'messageSessionCallback' cannot be null");
        this.remoteFileTemplate = remoteFileTemplate;
        this.messageSessionCallback = messageSessionCallback;
        this.fileNameProcessor = null;
        this.command = null;
        this.remoteFileTemplateExplicitlySet(true);
    }

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, String command, @Nullable String expression) {
        this(sessionFactory, Command.toCommand(command), expression);
    }

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, Command command, @Nullable String expression) {
        this(new RemoteFileTemplate<F>(sessionFactory), command, expression);
        this.remoteFileTemplateExplicitlySet(false);
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, String command, @Nullable String expression) {
        this(remoteFileTemplate, Command.toCommand(command), expression);
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, Command command, @Nullable String expressionArg) {
        boolean expressionNeeded;
        Assert.notNull(remoteFileTemplate, (String)"'remoteFileTemplate' cannot be null");
        this.remoteFileTemplate = remoteFileTemplate;
        this.command = command;
        String expression = expressionArg;
        boolean bl = expressionNeeded = !Command.LS.equals((Object)this.command) && !Command.NLST.equals((Object)this.command) && !Command.PUT.equals((Object)this.command) && !Command.MPUT.equals((Object)this.command);
        if (!StringUtils.hasText((String)expression) && expressionNeeded) {
            expression = "payload";
        }
        if (!StringUtils.hasText((String)expression)) {
            this.fileNameProcessor = null;
        } else {
            Expression parsedExpression = new SpelExpressionParser().parseExpression(expression);
            this.fileNameProcessor = new ExpressionEvaluatingMessageProcessor(parsedExpression);
            this.setPrimaryExpression(parsedExpression);
        }
        this.messageSessionCallback = null;
        this.remoteFileTemplateExplicitlySet(true);
    }

    protected final void remoteFileTemplateExplicitlySet(boolean remoteFileTemplateExplicitlySet) {
        this.remoteFileTemplateExplicitlySet = remoteFileTemplateExplicitlySet;
    }

    protected void assertRemoteFileTemplateMutability(String propertyName) {
        Assert.state((!this.remoteFileTemplateExplicitlySet ? 1 : 0) != 0, () -> "The '" + propertyName + "' must be set on the externally provided: " + this.remoteFileTemplate);
    }

    public void setOptions(String options) {
        Assert.hasText((String)options, (String)"'options' must not be empty.");
        this.options.clear();
        Arrays.stream(options.split("\\s")).filter(StringUtils::hasText).map(s -> Option.toOption(s.trim())).forEach(this.options::add);
    }

    public void setOption(Option ... options) {
        Assert.notNull((Object)options, (String)"'options' must not be null");
        Assert.noNullElements((Object[])options, (String)"'options' cannot contain null element");
        this.options.clear();
        Collections.addAll(this.options, options);
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.assertRemoteFileTemplateMutability("remoteFileSeparator");
        this.remoteFileTemplate.setRemoteFileSeparator(remoteFileSeparator);
    }

    public void setLocalDirectory(File localDirectory) {
        if (localDirectory != null) {
            this.localDirectoryExpression = new ValueExpression((Object)localDirectory);
        }
    }

    public void setLocalDirectoryExpression(Expression localDirectoryExpression) {
        this.localDirectoryExpression = localDirectoryExpression;
    }

    public void setLocalDirectoryExpressionString(String localDirectoryExpression) {
        this.localDirectoryExpression = EXPRESSION_PARSER.parseExpression(localDirectoryExpression);
    }

    public void setAutoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        this.autoCreateLocalDirectory = autoCreateLocalDirectory;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.assertRemoteFileTemplateMutability("temporaryFileSuffix");
        this.remoteFileTemplate.setTemporaryFileSuffix(temporaryFileSuffix);
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.assertRemoteFileTemplateMutability("autoCreateDirectory");
        this.remoteFileTemplate.setAutoCreateDirectory(autoCreateDirectory);
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        this.assertRemoteFileTemplateMutability("remoteDirectoryExpression");
        this.remoteFileTemplate.setRemoteDirectoryExpression(remoteDirectoryExpression);
    }

    public void setTemporaryRemoteDirectoryExpression(Expression temporaryRemoteDirectoryExpression) {
        this.assertRemoteFileTemplateMutability("temporaryRemoteDirectoryExpression");
        this.remoteFileTemplate.setTemporaryRemoteDirectoryExpression(temporaryRemoteDirectoryExpression);
    }

    public void setFileNameExpression(Expression fileNameExpression) {
        this.assertRemoteFileTemplateMutability("fileNameExpression");
        this.remoteFileTemplate.setFileNameExpression(fileNameExpression);
    }

    public void setUseTemporaryFileName(boolean useTemporaryFileName) {
        this.assertRemoteFileTemplateMutability("useTemporaryFileName");
        this.remoteFileTemplate.setUseTemporaryFileName(useTemporaryFileName);
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.assertRemoteFileTemplateMutability("fileNameGenerator");
        this.remoteFileTemplate.setFileNameGenerator(fileNameGenerator);
    }

    public void setCharset(String charset) {
        this.assertRemoteFileTemplateMutability("charset");
        this.remoteFileTemplate.setCharset(charset);
    }

    public void setFilter(FileListFilter<F> filter) {
        this.filter = filter;
        boolean bl = this.filterAfterEnhancement = filter != null && filter.isForRecursion() && filter.supportsSingleFileFiltering() && this.options.contains((Object)Option.RECURSIVE);
        if (filter != null && !filter.isForRecursion()) {
            this.logger.warn((Object)"When using recursion, you will normally want to set the filter's 'forRecursion' property; otherwise files added deep into the directory tree may not be detected");
        }
    }

    public void setMputFilter(FileListFilter<File> filter) {
        this.mputFilter = filter;
    }

    public void setRenameExpression(Expression renameExpression) {
        this.renameProcessor = new ExpressionEvaluatingMessageProcessor(renameExpression);
    }

    public void setRenameExpressionString(String renameExpression) {
        Assert.hasText((String)renameExpression, (String)"'renameExpression' cannot be empty");
        this.setRenameExpression(EXPRESSION_PARSER.parseExpression(renameExpression));
    }

    public void setLocalFilenameGeneratorExpression(Expression localFilenameGeneratorExpression) {
        Assert.notNull((Object)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be null");
        this.localFilenameGeneratorExpression = localFilenameGeneratorExpression;
    }

    public void setLocalFilenameGeneratorExpressionString(String localFilenameGeneratorExpression) {
        Assert.hasText((String)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be empty");
        this.localFilenameGeneratorExpression = EXPRESSION_PARSER.parseExpression(localFilenameGeneratorExpression);
    }

    public void setFileExistsMode(FileExistsMode fileExistsMode) {
        this.fileExistsMode = fileExistsMode;
        if (FileExistsMode.APPEND.equals((Object)fileExistsMode)) {
            this.remoteFileTemplate.setUseTemporaryFileName(false);
        }
    }

    public void setChmodOctal(String chmod) {
        Assert.notNull((Object)chmod, (String)"'chmod' cannot be null");
        this.setChmod(Integer.parseInt(chmod, 8));
    }

    public void setChmod(int chmod) {
        Assert.isTrue((boolean)this.isChmodCapable(), (String)"chmod operations not supported");
        this.chmod = chmod;
    }

    public boolean isChmodCapable() {
        return false;
    }

    protected final RemoteFileTemplate<F> getRemoteFileTemplate() {
        return this.remoteFileTemplate;
    }

    protected void doInit() {
        Assert.state((this.command != null || this.messageSessionCallback != null ? 1 : 0) != 0, (String)"'command' or 'messageSessionCallback' must be specified.");
        if (Command.RM.equals((Object)this.command) || Command.GET.equals((Object)this.command)) {
            Assert.isNull(this.filter, (String)"Filters are not supported with the rm and get commands");
        }
        if (Command.GET.equals((Object)this.command) && !this.options.contains((Object)Option.STREAM) || Command.MGET.equals((Object)this.command)) {
            Assert.notNull((Object)this.localDirectoryExpression, (String)"localDirectory must not be null");
            if (this.localDirectoryExpression instanceof ValueExpression) {
                this.setupLocalDirectory();
            }
        }
        if (Command.MGET.equals((Object)this.command)) {
            Assert.isTrue((!this.options.contains((Object)Option.SUBDIRS) ? 1 : 0) != 0, (String)("Cannot use " + Option.SUBDIRS.toString() + " when using 'mget' use " + Option.RECURSIVE.toString() + " to obtain files in subdirectories"));
        }
        this.populateBeanFactoryIntoComponentsIfAny();
        if (!this.remoteFileTemplateExplicitlySet) {
            this.remoteFileTemplate.afterPropertiesSet();
        }
    }

    private void populateBeanFactoryIntoComponentsIfAny() {
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory != null) {
            if (this.fileNameProcessor != null) {
                this.fileNameProcessor.setBeanFactory(beanFactory);
            }
            this.renameProcessor.setBeanFactory(beanFactory);
            this.remoteFileTemplate.setBeanFactory(beanFactory);
        }
    }

    private void setupLocalDirectory() {
        block6: {
            File localDirectory = ExpressionUtils.expressionToFile((Expression)this.localDirectoryExpression, (EvaluationContext)ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory()), null, (String)"localDirectoryExpression");
            if (!localDirectory.exists()) {
                try {
                    if (this.autoCreateLocalDirectory) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("The '" + localDirectory + "' directory doesn't exist; Will create."));
                        }
                        if (!localDirectory.mkdirs()) {
                            throw new IOException("Failed to make local directory: " + localDirectory);
                        }
                        break block6;
                    }
                    throw new FileNotFoundException(localDirectory.getName());
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        if (this.command != null) {
            switch (this.command) {
                case LS: {
                    return this.doLs(requestMessage);
                }
                case NLST: {
                    return this.doNlst(requestMessage);
                }
                case GET: {
                    return this.doGet(requestMessage);
                }
                case MGET: {
                    return this.doMget(requestMessage);
                }
                case RM: {
                    return this.doRm(requestMessage);
                }
                case MV: {
                    return this.doMv(requestMessage);
                }
                case PUT: {
                    return this.doPut(requestMessage);
                }
                case MPUT: {
                    return this.doMput(requestMessage);
                }
            }
        }
        return this.remoteFileTemplate.execute(session -> this.messageSessionCallback.doInSession(session, requestMessage));
    }

    private Object doLs(Message<?> requestMessage) {
        String dir;
        String string = dir = this.fileNameProcessor != null ? (String)this.fileNameProcessor.processMessage(requestMessage) : null;
        if (dir != null && !dir.endsWith(this.remoteFileTemplate.getRemoteFileSeparator())) {
            dir = dir + this.remoteFileTemplate.getRemoteFileSeparator();
        }
        String fullDir = dir;
        return this.remoteFileTemplate.execute(session -> {
            List<?> payload = this.ls(requestMessage, session, fullDir);
            return this.getMessageBuilderFactory().withPayload(payload).setHeader("file_remoteDirectory", (Object)fullDir).setHeader("file_remoteHostPort", (Object)session.getHostPort());
        });
    }

    private Object doNlst(Message<?> requestMessage) {
        String dir;
        String string = dir = this.fileNameProcessor != null ? (String)this.fileNameProcessor.processMessage(requestMessage) : null;
        if (dir != null && !dir.endsWith(this.remoteFileTemplate.getRemoteFileSeparator())) {
            dir = dir + this.remoteFileTemplate.getRemoteFileSeparator();
        }
        String fullDir = dir;
        return this.remoteFileTemplate.execute(session -> {
            List<String> payload = this.nlst(requestMessage, session, fullDir);
            return this.getMessageBuilderFactory().withPayload(payload).setHeader("file_remoteDirectory", (Object)fullDir).setHeader("file_remoteHostPort", (Object)session.getHostPort());
        });
    }

    protected List<String> nlst(Message<?> message, Session<F> session, String dir) throws IOException {
        String remoteDirectory = this.buildRemotePath(dir, "");
        List<String> fileNames = Arrays.asList(session.listNames(remoteDirectory));
        if (!this.options.contains((Object)Option.NOSORT)) {
            Collections.sort(fileNames);
        }
        return fileNames;
    }

    private Object doGet(Message<?> requestMessage) {
        String remoteFilePath = this.obtainRemoteFilePath(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        Session<F> session = null;
        if (this.options.contains((Object)Option.STREAM)) {
            session = this.remoteFileTemplate.getSessionFactory().getSession();
            try {
                InputStream payload = session.readRaw(remoteFilePath);
                return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_remoteHostPort", (Object)session.getHostPort()).setHeader("closeableResource", session);
            }
            catch (IOException e) {
                throw new MessageHandlingException(requestMessage, "Error handling message in the [" + (Object)((Object)this) + "]. Failed to get the remote file [" + remoteFilePath + "] as a stream", (Throwable)e);
            }
        }
        return this.remoteFileTemplate.execute(session1 -> {
            File getPayload = this.get(requestMessage, session1, remoteDir, remoteFilePath, remoteFilename, null);
            return this.getMessageBuilderFactory().withPayload((Object)getPayload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_remoteHostPort", (Object)session1.getHostPort());
        });
    }

    private Object doMget(Message<?> requestMessage) {
        String remoteFilePath = this.obtainRemoteFilePath(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        return this.remoteFileTemplate.execute(session -> {
            List<File> payload = this.mGet(requestMessage, session, remoteDir, remoteFilename);
            return this.getMessageBuilderFactory().withPayload(payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_remoteHostPort", (Object)session.getHostPort());
        });
    }

    private Object doRm(Message<?> requestMessage) {
        String remoteFilePath = this.obtainRemoteFilePath(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        return this.remoteFileTemplate.execute(session -> {
            boolean payload = this.rm(requestMessage, session, remoteFilePath);
            return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_remoteHostPort", (Object)session.getHostPort());
        });
    }

    protected boolean rm(Message<?> message, Session<F> session, String remoteFilePath) throws IOException {
        return session.remove(remoteFilePath);
    }

    private Object doMv(Message<?> requestMessage) {
        String remoteFilePath = this.obtainRemoteFilePath(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        String remoteFileNewPath = (String)this.renameProcessor.processMessage(requestMessage);
        Assert.hasLength((String)remoteFileNewPath, (String)"New filename cannot be empty");
        return this.remoteFileTemplate.execute(session -> {
            Boolean result = this.mv(requestMessage, session, remoteFilePath, remoteFileNewPath);
            return this.getMessageBuilderFactory().withPayload((Object)result).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_renameTo", (Object)remoteFileNewPath).setHeader("file_remoteHostPort", (Object)session.getHostPort());
        });
    }

    private String obtainRemoteFilePath(Message<?> requestMessage) {
        String remoteFilePath = (String)this.fileNameProcessor.processMessage(requestMessage);
        Assert.state((remoteFilePath != null ? 1 : 0) != 0, () -> "The 'fileNameProcessor' evaluated to null 'remoteFilePath' from message: " + requestMessage);
        return remoteFilePath;
    }

    protected boolean mv(Message<?> message, Session<F> session, String remoteFilePath, String remoteFileNewPath) throws IOException {
        int lastSeparator = remoteFileNewPath.lastIndexOf(this.remoteFileTemplate.getRemoteFileSeparator());
        if (lastSeparator > 0) {
            String remoteFileDirectory = remoteFileNewPath.substring(0, lastSeparator + 1);
            RemoteFileUtils.makeDirectories(remoteFileDirectory, session, this.remoteFileTemplate.getRemoteFileSeparator(), this.logger);
        }
        session.rename(remoteFilePath, remoteFileNewPath);
        return true;
    }

    private String doPut(Message<?> requestMessage) {
        return this.doPut(requestMessage, null);
    }

    private String doPut(Message<?> requestMessage, String subDirectory) {
        return this.remoteFileTemplate.invoke(template -> this.put(requestMessage, template.getSession(), subDirectory));
    }

    protected String put(Message<?> message, Session<F> session, String subDirectory) {
        String path = this.remoteFileTemplate.send(message, subDirectory, new FileExistsMode[]{this.fileExistsMode});
        if (path == null) {
            throw new MessagingException(message, "No local file found for " + message);
        }
        if (this.chmod != null && this.isChmodCapable()) {
            this.doChmod(this.remoteFileTemplate, path, this.chmod);
        }
        return path;
    }

    protected void doChmod(RemoteFileOperations<F> remoteFileOperations, String path, int chmodToSet) {
    }

    private Object doMput(Message<?> requestMessage) {
        File file = null;
        Object payload = requestMessage.getPayload();
        if (payload instanceof File) {
            file = (File)payload;
        } else if (payload instanceof String) {
            file = new File((String)payload);
        } else if (!(payload instanceof Collection)) {
            throw new IllegalArgumentException("Only File or String payloads (or Collection of File/String) allowed for 'mput', received: " + payload.getClass());
        }
        if (payload instanceof Collection) {
            return ((Collection)payload).stream().map(p -> this.doMput((Message<?>)new MutableMessage(p, (Map)requestMessage.getHeaders()))).collect(Collectors.toList());
        }
        if (!file.isDirectory()) {
            return this.doPut(requestMessage);
        }
        File localDir = file;
        return this.remoteFileTemplate.invoke(t -> this.mPut(requestMessage, t.getSession(), localDir));
    }

    protected List<String> mPut(Message<?> message, Session<F> session, File localDir) {
        return this.putLocalDirectory(message, localDir, null);
    }

    private List<String> putLocalDirectory(Message<?> requestMessage, File file, String subDirectory) {
        List<File> filteredFiles = this.filterMputFiles(file.listFiles());
        ArrayList<String> replies = new ArrayList<String>();
        try {
            for (File filteredFile : filteredFiles) {
                if (!filteredFile.isDirectory()) {
                    String path = this.doPut((Message<?>)new MutableMessage((Object)filteredFile, (Map)requestMessage.getHeaders()), subDirectory);
                    if (path != null) {
                        replies.add(path);
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("File " + filteredFile.getAbsolutePath() + " removed before transfer; ignoring"));
                    continue;
                }
                if (!this.options.contains((Object)Option.RECURSIVE)) continue;
                String newSubDirectory = (StringUtils.hasText((String)subDirectory) ? subDirectory + this.remoteFileTemplate.getRemoteFileSeparator() : "") + filteredFile.getName();
                replies.addAll(this.putLocalDirectory(requestMessage, filteredFile, newSubDirectory));
            }
        }
        catch (RuntimeException ex) {
            throw this.handlePutException(requestMessage, subDirectory, filteredFiles, replies, ex);
        }
        return replies;
    }

    private RuntimeException handlePutException(Message<?> requestMessage, String subDirectory, List<File> filteredFiles, List<String> replies, RuntimeException ex) {
        if (replies.size() > 0 || ex instanceof PartialSuccessException) {
            return new PartialSuccessException(requestMessage, "Partially successful 'mput' operation" + (subDirectory == null ? "" : " on " + subDirectory), (Throwable)ex, replies, filteredFiles);
        }
        return ex;
    }

    protected List<?> ls(Message<?> message, Session<F> session, String dir) throws IOException {
        List<F> lsFiles = this.listFilesInRemoteDir(session, dir, "");
        if (!this.options.contains((Object)Option.LINKS)) {
            this.purgeLinks(lsFiles);
        }
        if (!this.options.contains((Object)Option.ALL)) {
            this.purgeDots(lsFiles);
        }
        if (this.options.contains((Object)Option.NAME_ONLY)) {
            ArrayList<String> results = new ArrayList<String>();
            for (F file : lsFiles) {
                results.add(this.getFilename(file));
            }
            if (!this.options.contains((Object)Option.NOSORT)) {
                Collections.sort(results);
            }
            return results;
        }
        List<AbstractFileInfo<F>> canonicalFiles = this.asFileInfoList(lsFiles);
        for (AbstractFileInfo<F> file : canonicalFiles) {
            file.setRemoteDirectory(dir);
        }
        if (!this.options.contains((Object)Option.NOSORT)) {
            Collections.sort(canonicalFiles);
        }
        return canonicalFiles;
    }

    private List<F> listFilesInRemoteDir(Session<F> session, String directory, String subDirectory) throws IOException {
        ArrayList lsFiles = new ArrayList();
        String remoteDirectory = this.buildRemotePath(directory, subDirectory);
        F[] list = session.list(remoteDirectory);
        List<F> files = !this.filterAfterEnhancement ? this.filterFiles(list) : Arrays.asList(list);
        if (!ObjectUtils.isEmpty(files)) {
            for (F file : files) {
                if (file == null) continue;
                this.processFile(session, directory, subDirectory, lsFiles, this.options.contains((Object)Option.RECURSIVE), file);
            }
        }
        return lsFiles;
    }

    private String buildRemotePath(String parent, String child) {
        String remotePath = null;
        if (parent != null) {
            remotePath = parent + child;
        } else if (StringUtils.hasText((String)child)) {
            remotePath = "." + this.remoteFileTemplate.getRemoteFileSeparator() + child;
        }
        return remotePath;
    }

    protected final List<F> filterFiles(F[] files) {
        return this.filter != null ? this.filter.filterFiles(files) : Arrays.asList(files);
    }

    protected final F filterFile(F file) {
        if (this.filter.accept(file)) {
            return file;
        }
        return null;
    }

    private void processFile(Session<F> session, String directory, String subDirectory, List<F> lsFiles, boolean recursion, F file) throws IOException {
        F fileToAdd = file;
        if (recursion && StringUtils.hasText((String)subDirectory)) {
            fileToAdd = this.enhanceNameWithSubDirectory(file, subDirectory);
        }
        if (this.filterAfterEnhancement && !this.filter.accept(fileToAdd)) {
            return;
        }
        String fileName = this.getFilename(fileToAdd);
        boolean isDirectory = this.isDirectory(file);
        boolean isDots = this.hasDots(fileName);
        if (!(!this.options.contains((Object)Option.SUBDIRS) && isDirectory || isDots && !this.options.contains((Object)Option.ALL))) {
            lsFiles.add(fileToAdd);
        }
        if (recursion && isDirectory && !isDots) {
            lsFiles.addAll(this.listFilesInRemoteDir(session, directory, fileName + this.remoteFileTemplate.getRemoteFileSeparator()));
        }
    }

    private boolean hasDots(String fileName) {
        String fileSeparator = this.remoteFileTemplate.getRemoteFileSeparator();
        return ".".equals(fileName) || "..".equals(fileName) || fileName.endsWith(fileSeparator + ".") || fileName.endsWith(fileSeparator + "..");
    }

    protected final List<File> filterMputFiles(File[] files) {
        if (files == null) {
            return Collections.emptyList();
        }
        return this.mputFilter != null ? this.mputFilter.filterFiles((File[])files) : Arrays.asList(files);
    }

    protected void purgeLinks(List<F> lsFiles) {
        lsFiles.removeIf(this::isLink);
    }

    protected void purgeDots(List<F> lsFiles) {
        lsFiles.removeIf(f -> this.getFilename(f).startsWith("."));
    }

    protected File get(Message<?> message, Session<F> session, String remoteDir, String remoteFilePath, String remoteFilename, F fileInfoParam) throws IOException {
        boolean replacing;
        F fileInfo = fileInfoParam;
        if (fileInfo == null) {
            F[] files = session.list(remoteFilePath);
            if (files == null) {
                throw new MessagingException("Session returned null when listing " + remoteFilePath);
            }
            if (files.length != 1 || files[0] == null || this.isDirectory(files[0]) || this.isLink(files[0])) {
                throw new MessagingException(remoteFilePath + " is not a file");
            }
            fileInfo = files[0];
        }
        File localFile = new File(this.generateLocalDirectory(message, remoteDir), this.generateLocalFileName(message, remoteFilename));
        FileExistsMode existsMode = this.fileExistsMode;
        boolean appending = FileExistsMode.APPEND.equals((Object)existsMode);
        boolean exists = localFile.exists();
        boolean bl = replacing = FileExistsMode.REPLACE.equals((Object)existsMode) || exists && FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)existsMode) && localFile.lastModified() != this.getModified(fileInfo);
        if (!exists || appending || replacing) {
            String tempFileName = localFile.getAbsolutePath() + this.remoteFileTemplate.getTemporaryFileSuffix();
            File tempFile = new File(tempFileName);
            BufferedOutputStream outputStream = appending ? new BufferedOutputStream(new FileOutputStream(localFile, true)) : new BufferedOutputStream(new FileOutputStream(tempFile));
            if (replacing && !localFile.delete() && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Failed to delete " + localFile));
            }
            try {
                session.read(remoteFilePath, outputStream);
            }
            catch (Exception e) {
                ((OutputStream)outputStream).close();
                if (!tempFile.delete() && this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Failed to delete tempFile " + tempFile));
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MessagingException("Failure occurred while copying from remote to local directory", (Throwable)e);
            }
            finally {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Exception exception) {}
            }
            if (!appending && !tempFile.renameTo(localFile)) {
                throw new MessagingException("Failed to rename local file");
            }
            if ((this.options.contains((Object)Option.PRESERVE_TIMESTAMP) || FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)existsMode)) && !localFile.setLastModified(this.getModified(fileInfo)) && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Failed to set lastModified on " + localFile));
            }
            if (this.options.contains((Object)Option.DELETE)) {
                boolean result = session.remove(remoteFilePath);
                if (!result) {
                    this.logger.error((Object)("Failed to delete: " + remoteFilePath));
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(remoteFilePath + " deleted"));
                }
            }
        } else if (FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)existsMode)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Local file '" + localFile + "' has the same modified timestamp, ignored"));
            }
            if (this.command.equals((Object)Command.MGET)) {
                localFile = null;
            }
        } else {
            if (!FileExistsMode.IGNORE.equals((Object)existsMode)) {
                throw new MessageHandlingException(message, "Error handling message in the [" + (Object)((Object)this) + "]. Local file " + localFile + " already exists");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Existing file skipped: " + localFile));
            }
            if (this.command.equals((Object)Command.MGET)) {
                localFile = null;
            }
        }
        return localFile;
    }

    protected List<File> mGet(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        if (this.options.contains((Object)Option.RECURSIVE)) {
            if (this.logger.isWarnEnabled() && !"*".equals(remoteFilename)) {
                this.logger.warn((Object)"File name pattern must be '*' when using recursion");
            }
            this.options.remove((Object)Option.NAME_ONLY);
            return this.mGetWithRecursion(message, session, remoteDirectory, remoteFilename);
        }
        return this.mGetWithoutRecursion(message, session, remoteDirectory, remoteFilename);
    }

    private List<File> mGetWithoutRecursion(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        String remotePath = this.buildRemotePath(remoteDirectory, remoteFilename);
        List<AbstractFileInfo<F>> remoteFiles = this.lsRemoteFilesForMget(message, session, remoteDirectory, remoteFilename, remotePath);
        try {
            for (AbstractFileInfo<F> lsEntry : remoteFiles) {
                File file;
                if (lsEntry.isDirectory() || (file = this.getRemoteFileForMget(message, session, remoteDirectory, lsEntry)) == null) continue;
                files.add(file);
            }
        }
        catch (Exception ex) {
            throw this.processMgetException(message, remoteDirectory, files, remoteFiles, ex);
        }
        return files;
    }

    private RuntimeException processMgetException(Message<?> message, String remoteDirectory, List<File> files, List<AbstractFileInfo<F>> remoteFiles, Exception ex) {
        if (files.size() > 0) {
            return new PartialSuccessException(message, "Partially successful recursive 'mget' operation on " + (remoteDirectory != null ? remoteDirectory : "Client Working Directory"), (Throwable)ex, files, remoteFiles);
        }
        if (ex instanceof MessagingException) {
            return (MessagingException)ex;
        }
        if (ex instanceof IOException) {
            throw new UncheckedIOException((IOException)ex);
        }
        return new MessagingException("Failed to process MGET", (Throwable)ex);
    }

    private List<File> mGetWithRecursion(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        List<AbstractFileInfo<F>> fileNames = this.lsRemoteFilesForMget(message, session, remoteDirectory, remoteFilename, remoteDirectory);
        try {
            for (AbstractFileInfo<F> lsEntry : fileNames) {
                File file = this.getRemoteFileForMget(message, session, remoteDirectory, lsEntry);
                if (file == null) continue;
                files.add(file);
            }
        }
        catch (Exception ex) {
            throw this.processMgetException(message, remoteDirectory, files, fileNames, ex);
        }
        return files;
    }

    private List<AbstractFileInfo<F>> lsRemoteFilesForMget(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename, String remotePath) throws IOException {
        List<AbstractFileInfo<F>> remoteFiles = this.ls(message, session, remotePath);
        if (remoteFiles.size() == 0 && this.options.contains((Object)Option.EXCEPTION_WHEN_EMPTY)) {
            throw new MessagingException("No files found at " + (remoteDirectory != null ? remoteDirectory : "Client Working Directory") + " with pattern " + remoteFilename);
        }
        return remoteFiles;
    }

    private File getRemoteFileForMget(Message<?> message, Session<F> session, String remoteDirectory, AbstractFileInfo<F> lsEntry) throws IOException {
        String fullFileName = remoteDirectory != null ? remoteDirectory + this.getFilename(lsEntry) : this.getFilename(lsEntry);
        String fileName = this.getRemoteFilename(fullFileName);
        String actualRemoteDirectory = this.getRemoteDirectory(fullFileName, fileName);
        return this.get(message, session, actualRemoteDirectory, fullFileName, fileName, lsEntry.getFileInfo());
    }

    private String getRemoteDirectory(String remoteFilePath, String remoteFilename) {
        String remoteDir = remoteFilePath.substring(0, remoteFilePath.lastIndexOf(remoteFilename));
        if (remoteDir.length() == 0) {
            return null;
        }
        return remoteDir;
    }

    protected String getRemoteFilename(String remoteFilePath) {
        int index = remoteFilePath.lastIndexOf(this.remoteFileTemplate.getRemoteFileSeparator());
        if (index < 0) {
            return remoteFilePath;
        }
        return remoteFilePath.substring(index + 1);
    }

    private File generateLocalDirectory(Message<?> message, String remoteDirectory) {
        File localDir;
        StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (remoteDirectory != null) {
            evaluationContext.setVariable("remoteDirectory", (Object)remoteDirectory);
        }
        if (!(localDir = ExpressionUtils.expressionToFile((Expression)this.localDirectoryExpression, (EvaluationContext)evaluationContext, message, (String)"Local Directory")).exists()) {
            Assert.isTrue((boolean)localDir.mkdirs(), (String)("Failed to make local directory: " + localDir));
        }
        return localDir;
    }

    private String generateLocalFileName(Message<?> message, String remoteFileName) {
        if (this.localFilenameGeneratorExpression != null) {
            StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
            evaluationContext.setVariable("remoteFileName", (Object)remoteFileName);
            return (String)this.localFilenameGeneratorExpression.getValue((EvaluationContext)evaluationContext, message, String.class);
        }
        return remoteFileName;
    }

    protected abstract boolean isDirectory(F var1);

    protected abstract boolean isLink(F var1);

    protected abstract String getFilename(F var1);

    protected abstract String getFilename(AbstractFileInfo<F> var1);

    protected abstract long getModified(F var1);

    protected abstract List<AbstractFileInfo<F>> asFileInfoList(Collection<F> var1);

    protected abstract F enhanceNameWithSubDirectory(F var1, String var2);

    public static enum Option {
        NAME_ONLY("-1"),
        ALL("-a"),
        NOSORT("-f"),
        SUBDIRS("-dirs"),
        LINKS("-links"),
        PRESERVE_TIMESTAMP("-P"),
        EXCEPTION_WHEN_EMPTY("-x"),
        RECURSIVE("-R"),
        STREAM("-stream"),
        DELETE("-D");

        private final String option;

        private Option(String option) {
            this.option = option;
        }

        public String getOption() {
            return this.option;
        }

        public static Option toOption(String opt) {
            for (Option option : Option.values()) {
                if (!option.getOption().equals(opt)) continue;
                return option;
            }
            throw new IllegalArgumentException("No option with value '" + opt + "'");
        }
    }

    public static enum Command {
        LS("ls"),
        NLST("nlst"),
        GET("get"),
        RM("rm"),
        MGET("mget"),
        MV("mv"),
        PUT("put"),
        MPUT("mput");

        private final String command;

        private Command(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }

        public static Command toCommand(String cmd) {
            for (Command command : Command.values()) {
                if (!command.getCommand().equals(cmd)) continue;
                return command;
            }
            throw new IllegalArgumentException("No Command with value '" + cmd + "'");
        }
    }
}

