/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.synchronizer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.integration.endpoint.AbstractFetchLimitingMessageSource;
import org.springframework.integration.file.DefaultDirectoryScanner;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileReadingMessageSource;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.FileSystemPersistentAcceptOnceFileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.util.Assert;

public abstract class AbstractInboundFileSynchronizingMessageSource<F>
extends AbstractFetchLimitingMessageSource<File>
implements ManageableLifecycle {
    private final AbstractInboundFileSynchronizer<F> synchronizer;
    private final LocalFileReadingMessageSource fileSource;
    private boolean autoCreateLocalDirectory = true;
    private File localDirectory;
    private FileListFilter<File> localFileListFilter;
    private boolean scannerExplicitlySet = false;
    private volatile boolean running;

    public AbstractInboundFileSynchronizingMessageSource(AbstractInboundFileSynchronizer<F> synchronizer) {
        this(synchronizer, null);
    }

    public AbstractInboundFileSynchronizingMessageSource(AbstractInboundFileSynchronizer<F> synchronizer, Comparator<File> comparator) {
        Assert.notNull(synchronizer, (String)"synchronizer must not be null");
        this.synchronizer = synchronizer;
        this.fileSource = comparator == null ? new LocalFileReadingMessageSource() : new LocalFileReadingMessageSource(comparator);
    }

    public void setAutoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        this.autoCreateLocalDirectory = autoCreateLocalDirectory;
    }

    public void setLocalDirectory(File localDirectory) {
        this.localDirectory = localDirectory;
    }

    public void setLocalFilter(FileListFilter<File> localFileListFilter) {
        this.localFileListFilter = localFileListFilter;
    }

    public void setUseWatchService(boolean useWatchService) {
        this.fileSource.setUseWatchService(useWatchService);
        if (useWatchService) {
            this.fileSource.setWatchEvents(FileReadingMessageSource.WatchEventType.CREATE, FileReadingMessageSource.WatchEventType.MODIFY, FileReadingMessageSource.WatchEventType.DELETE);
        }
    }

    public void setScanner(DirectoryScanner scanner) {
        this.fileSource.setScanner(scanner);
        this.scannerExplicitlySet = true;
    }

    public AbstractInboundFileSynchronizer<F> getSynchronizer() {
        return this.synchronizer;
    }

    protected void onInit() {
        Assert.notNull((Object)this.localDirectory, (String)"localDirectory must not be null");
        try {
            if (!this.localDirectory.exists()) {
                if (this.autoCreateLocalDirectory) {
                    this.logger.debug(() -> "The '" + this.localDirectory + "' directory doesn't exist; Will create.");
                    if (!this.localDirectory.mkdirs()) {
                        this.logger.warn(() -> "Failed to create directories for " + this.localDirectory);
                    }
                } else {
                    throw new FileNotFoundException(this.localDirectory.getName());
                }
            }
            this.fileSource.setDirectory(this.localDirectory);
            this.initFiltersAndScanner();
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory != null) {
                this.fileSource.setBeanFactory(beanFactory);
            }
            this.fileSource.afterPropertiesSet();
            this.synchronizer.afterPropertiesSet();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanInitializationException("Failure during initialization for: " + this, (Throwable)e);
        }
    }

    private void initFiltersAndScanner() {
        if (this.localFileListFilter == null) {
            this.localFileListFilter = new FileSystemPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), this.getComponentName());
        }
        FileListFilter<File> filter = this.buildFilter();
        if (this.scannerExplicitlySet) {
            Assert.state((!this.fileSource.isUseWatchService() ? 1 : 0) != 0, (String)"'useWatchService' and 'scanner' are mutually exclusive.");
            this.fileSource.getScanner().setFilter(filter);
        } else if (!this.fileSource.isUseWatchService()) {
            DefaultDirectoryScanner directoryScanner = new DefaultDirectoryScanner();
            directoryScanner.setFilter(filter);
            this.fileSource.setScanner(directoryScanner);
        } else {
            this.fileSource.setFilter(filter);
        }
    }

    public void start() {
        this.running = true;
        this.fileSource.start();
    }

    public void stop() {
        this.running = false;
        try {
            this.fileSource.stop();
            this.synchronizer.close();
        }
        catch (IOException ex) {
            this.logger.error((Throwable)ex, (CharSequence)"Error closing synchronizer");
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public final AbstractIntegrationMessageBuilder<File> doReceive(int maxFetchSize) {
        String remoteFileUri;
        AbstractIntegrationMessageBuilder<File> messageBuilder = this.fileSource.doReceive();
        if (messageBuilder == null) {
            this.synchronizer.synchronizeToLocalDirectory(this.localDirectory, maxFetchSize);
            messageBuilder = this.fileSource.doReceive();
        }
        if (messageBuilder != null && (remoteFileUri = this.synchronizer.getRemoteFileMetadata((File)messageBuilder.getPayload())) != null) {
            URI uri = URI.create(remoteFileUri);
            messageBuilder.setHeader("file_remoteHostPort", (Object)(uri.getHost() + ":" + uri.getPort())).setHeader("file_remoteDirectory", (Object)uri.getPath()).setHeader("file_remoteFile", (Object)uri.getFragment());
        }
        return messageBuilder;
    }

    private FileListFilter<File> buildFilter() {
        Pattern completePattern = Pattern.compile("^.*(?<!" + this.synchronizer.getTemporaryFileSuffix() + ")$");
        return new CompositeFileListFilter<File>(Arrays.asList(this.localFileListFilter, new RegexPatternFileListFilter(completePattern)));
    }

    private static final class LocalFileReadingMessageSource
    extends FileReadingMessageSource {
        LocalFileReadingMessageSource() {
        }

        LocalFileReadingMessageSource(Comparator<File> receptionOrderComparator) {
            super(receptionOrderComparator);
        }

        @Override
        protected AbstractIntegrationMessageBuilder<File> doReceive() {
            return super.doReceive();
        }
    }
}

