/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultFileNameGenerator
extends AbstractExpressionEvaluator
implements FileNameGenerator {
    private volatile Expression expression = new FunctionExpression(message -> message.getHeaders().get((Object)"file_name"));

    public void setExpression(String expression) {
        Assert.hasText((String)expression, (String)"expression must not be empty");
        this.expression = EXPRESSION_PARSER.parseExpression(expression);
    }

    public void setHeaderName(String headerName) {
        Assert.notNull((Object)headerName, (String)"'headerName' must not be null");
        this.expression = new FunctionExpression(message -> message.getHeaders().get((Object)headerName));
    }

    @Override
    public String generateFileName(Message<?> message) {
        String name;
        Object filename = this.evaluateExpression(this.expression, message);
        if (filename instanceof String && StringUtils.hasText((String)(name = (String)filename))) {
            return name;
        }
        Object payload = message.getPayload();
        if (payload instanceof File) {
            File file = (File)payload;
            return file.getName();
        }
        return message.getHeaders().getId() + ".msg";
    }
}

