/*
 * Copyright 2019-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.file.remote.server;

import org.springframework.integration.events.IntegrationEvent;

/**
 * Base class for file server events. Typically, the source for these events will be some
 * kind of client/server session object containing information such as the client's ip
 * address.
 *
 * @author Gary Russell
 * @since 5.2
 *
 */
@SuppressWarnings("serial")
public abstract class FileServerEvent extends IntegrationEvent {

	public FileServerEvent(Object source) {
		super(source);
	}

	public FileServerEvent(Object source, Throwable cause) {
		super(source, cause);
	}

}
