/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.dsl;

import java.io.File;
import java.util.Comparator;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.dsl.RemoteFileInboundChannelAdapterSpec;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.ftp.filters.FtpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.ftp.filters.FtpRegexPatternFileListFilter;
import org.springframework.integration.ftp.filters.FtpSimplePatternFileListFilter;
import org.springframework.integration.ftp.inbound.FtpInboundFileSynchronizer;
import org.springframework.integration.ftp.inbound.FtpInboundFileSynchronizingMessageSource;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;

public class FtpInboundChannelAdapterSpec
extends RemoteFileInboundChannelAdapterSpec<FTPFile, FtpInboundChannelAdapterSpec, FtpInboundFileSynchronizingMessageSource> {
    FtpInboundChannelAdapterSpec(SessionFactory<FTPFile> sessionFactory, Comparator<File> comparator) {
        super((AbstractInboundFileSynchronizer)new FtpInboundFileSynchronizer(sessionFactory));
        this.target = new FtpInboundFileSynchronizingMessageSource((AbstractInboundFileSynchronizer<FTPFile>)this.synchronizer, comparator);
    }

    public FtpInboundChannelAdapterSpec patternFilter(String pattern) {
        return (FtpInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<FTPFile>)new FtpSimplePatternFileListFilter(pattern)));
    }

    public FtpInboundChannelAdapterSpec regexFilter(String regex) {
        return (FtpInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<FTPFile>)new FtpRegexPatternFileListFilter(regex)));
    }

    private CompositeFileListFilter<FTPFile> composeFilters(FileListFilter<FTPFile> fileListFilter) {
        CompositeFileListFilter compositeFileListFilter = new CompositeFileListFilter();
        compositeFileListFilter.addFilters(new FileListFilter[]{fileListFilter, new FtpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "ftpMessageSource")});
        return compositeFileListFilter;
    }
}

