/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.session;

import java.io.IOException;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.ftp.FTPSClient;
import org.springframework.integration.ftp.session.AbstractFtpSessionFactory;
import org.springframework.integration.util.JavaUtils;
import org.springframework.util.StringUtils;

public class DefaultFtpsSessionFactory
extends AbstractFtpSessionFactory<FTPSClient> {
    private Boolean useClientMode;
    private Boolean sessionCreation;
    private String authValue;
    private TrustManager trustManager;
    private String[] cipherSuites;
    private String[] protocols;
    private KeyManager keyManager;
    private Boolean needClientAuth;
    private Boolean wantsClientAuth;
    private boolean implicit = false;
    private String prot = "P";
    private String protocol;

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setUseClientMode(Boolean useClientMode) {
        this.useClientMode = useClientMode;
    }

    public void setSessionCreation(Boolean sessionCreation) {
        this.sessionCreation = sessionCreation;
    }

    public void setAuthValue(String authValue) {
        this.authValue = authValue;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = Arrays.copyOf(cipherSuites, cipherSuites.length);
    }

    public void setProtocols(String[] protocols) {
        this.protocols = Arrays.copyOf(protocols, protocols.length);
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setNeedClientAuth(Boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void setWantsClientAuth(Boolean wantsClientAuth) {
        this.wantsClientAuth = wantsClientAuth;
    }

    public void setProt(String prot) {
        this.prot = prot;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    @Override
    protected FTPSClient createClientInstance() {
        try {
            if (StringUtils.hasText((String)this.protocol)) {
                return new FTPSClient(this.protocol, this.implicit);
            }
            return new FTPSClient(this.implicit);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Failed to create FTPS client.", e);
        }
    }

    @Override
    protected void postProcessClientAfterConnect(FTPSClient ftpsClient) throws IOException {
        ftpsClient.execPBSZ(0L);
        ftpsClient.execPROT(this.prot);
    }

    @Override
    protected void postProcessClientBeforeConnect(FTPSClient ftpsClient) {
        JavaUtils.INSTANCE.acceptIfHasText(this.authValue, arg_0 -> ((FTPSClient)ftpsClient).setAuthValue(arg_0)).acceptIfNotNull((Object)this.trustManager, arg_0 -> ((FTPSClient)ftpsClient).setTrustManager(arg_0)).acceptIfNotNull((Object)this.cipherSuites, arg_0 -> ((FTPSClient)ftpsClient).setEnabledCipherSuites(arg_0)).acceptIfNotNull((Object)this.protocols, arg_0 -> ((FTPSClient)ftpsClient).setEnabledProtocols(arg_0)).acceptIfNotNull((Object)this.sessionCreation, arg_0 -> ((FTPSClient)ftpsClient).setEnabledSessionCreation(arg_0)).acceptIfNotNull((Object)this.useClientMode, arg_0 -> ((FTPSClient)ftpsClient).setUseClientMode(arg_0)).acceptIfNotNull((Object)this.sessionCreation, arg_0 -> ((FTPSClient)ftpsClient).setEnabledSessionCreation(arg_0)).acceptIfNotNull((Object)this.keyManager, arg_0 -> ((FTPSClient)ftpsClient).setKeyManager(arg_0)).acceptIfNotNull((Object)this.needClientAuth, arg_0 -> ((FTPSClient)ftpsClient).setNeedClientAuth(arg_0)).acceptIfNotNull((Object)this.wantsClientAuth, arg_0 -> ((FTPSClient)ftpsClient).setWantClientAuth(arg_0));
    }
}

